/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.framework;

import com.thoughtworks.selenium.CommandProcessor;
import com.thoughtworks.selenium.HttpCommandProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.jboss.arquillian.ajocado.browser.Browser;
import org.jboss.arquillian.ajocado.command.CommandInterceptorProxy;
import org.jboss.arquillian.ajocado.command.CommandInterceptorProxyImpl;
import org.jboss.arquillian.ajocado.framework.AjaxSelenium;
import org.jboss.arquillian.ajocado.framework.ExtendedSelenium;
import org.jboss.arquillian.ajocado.framework.ExtendedTypedSeleniumImpl;
import org.jboss.arquillian.ajocado.framework.GrapheneConfiguration;
import org.jboss.arquillian.ajocado.framework.GrapheneSelenium;
import org.jboss.arquillian.ajocado.framework.PageExtensions;
import org.jboss.arquillian.ajocado.framework.SeleniumExtensions;
import org.jboss.arquillian.ajocado.framework.internal.GrapheneInitializator;
import org.jboss.arquillian.ajocado.framework.internal.PageExtensionsImpl;
import org.jboss.arquillian.ajocado.framework.internal.SeleniumExtensionsImpl;
import org.jboss.arquillian.ajocado.guard.RequestGuard;
import org.jboss.arquillian.ajocado.guard.RequestGuardImpl;
import org.jboss.arquillian.ajocado.javascript.JavaScript;
import org.jboss.arquillian.ajocado.locator.element.ElementLocationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrapheneSeleniumImpl
extends ExtendedTypedSeleniumImpl
implements GrapheneSelenium,
AjaxSelenium,
GrapheneInitializator {
    PageExtensions pageExtensions;
    SeleniumExtensions seleniumExtensions;
    RequestGuard requestInterceptor;
    CommandInterceptorProxyImpl interceptionProxy;

    private GrapheneSeleniumImpl() {
    }

    public GrapheneSeleniumImpl(String serverHost, int serverPort, Browser browser, URL contextPathURL) {
        HttpCommandProcessor commandProcessor = new HttpCommandProcessor(serverHost, serverPort, browser.inSeleniumRepresentation(), contextPathURL.toString());
        this.interceptionProxy = new CommandInterceptorProxyImpl((CommandProcessor)commandProcessor);
        this.selenium = new ExtendedSelenium(this.interceptionProxy.getCommandProcessorProxy());
        this.pageExtensions = new PageExtensionsImpl();
        this.seleniumExtensions = new SeleniumExtensionsImpl();
        this.requestInterceptor = new RequestGuardImpl();
    }

    public PageExtensions getPageExtensions() {
        return this.pageExtensions;
    }

    public SeleniumExtensions getSeleniumExtensions() {
        return this.seleniumExtensions;
    }

    public RequestGuard getRequestGuard() {
        return this.requestInterceptor;
    }

    public CommandInterceptorProxy getCommandInterceptionProxy() {
        return this.interceptionProxy;
    }

    public GrapheneSelenium clone() {
        GrapheneSeleniumImpl copy = new GrapheneSeleniumImpl();
        copy.pageExtensions = new PageExtensionsImpl();
        copy.seleniumExtensions = new SeleniumExtensionsImpl();
        copy.interceptionProxy = this.interceptionProxy.immutableCopy();
        copy.selenium = new ExtendedSelenium(copy.interceptionProxy.getCommandProcessorProxy());
        return copy;
    }

    @Override
    public void initializeBrowser() {
        this.start();
    }

    @Override
    public void configureBrowser() {
        if (this.configuration.isSeleniumMaximize()) {
            this.windowFocus();
            this.windowMaximize();
        }
        this.loadCustomLocationStrategies();
        this.setTimeout(this.configuration.getTimeout(GrapheneConfiguration.TimeoutType.DEFAULT));
        this.setSpeed(this.configuration.getSeleniumSpeed());
    }

    @Override
    public void initializeSeleniumExtensions() {
        List<String> seleniumExtensions = GrapheneSeleniumImpl.getExtensionsListFromResource("javascript/selenium-extensions-order.txt");
        this.getSeleniumExtensions().requireResources(seleniumExtensions);
        this.getSeleniumExtensions().registerCustomHandlers();
    }

    @Override
    public void initializePageExtensions() {
        List<String> pageExtensions = GrapheneSeleniumImpl.getExtensionsListFromResource("javascript/page-extensions-order.txt");
        this.getPageExtensions().loadFromResources(pageExtensions);
    }

    @Override
    public void finalizeBrowser() {
        this.setSpeed(0L);
        if (this.isStarted()) {
            this.deleteAllVisibleCookies();
            this.stop();
        }
    }

    public void restartBrowser() {
        this.finalizeBrowser();
        this.initializeBrowser();
        this.initializeSeleniumExtensions();
        this.initializePageExtensions();
        this.configureBrowser();
    }

    protected void loadCustomLocationStrategies() {
        JavaScript strategySource = JavaScript.fromResource((String)"javascript/selenium-location-strategies/jquery-location-strategy.js");
        this.addLocationStrategy(ElementLocationStrategy.JQUERY, strategySource);
    }

    protected static List<String> getExtensionsListFromResource(String resourceName) {
        try {
            return IOUtils.readLines((InputStream)ClassLoader.getSystemResourceAsStream(resourceName));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

