/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.javascript;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jboss.arquillian.graphene.javascript.Dependency;
import org.jboss.arquillian.graphene.javascript.ExecutionResolver;
import org.jboss.arquillian.graphene.javascript.InstallableJavaScript;
import org.jboss.arquillian.graphene.javascript.JSMethod;
import org.jboss.arquillian.graphene.javascript.JavaScript;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSTarget {
    private Class<?> jsInterface;
    private JavaScript javascriptAnnotation;
    private Dependency dependecyAnnotation;
    private ExecutionResolver resolver;

    public JSTarget(Class<?> jsInterface) {
        this.jsInterface = this.getImplementationOfInterface(jsInterface);
        this.javascriptAnnotation = this.jsInterface.getAnnotation(JavaScript.class);
        this.dependecyAnnotation = this.jsInterface.getAnnotation(Dependency.class);
        this.resolver = this.createResolver(this.javascriptAnnotation);
    }

    public Class<?> getInterface() {
        return this.jsInterface;
    }

    public String getName() {
        if ("".equals(this.javascriptAnnotation.value())) {
            return this.getInterface().getSimpleName();
        }
        return this.javascriptAnnotation.value();
    }

    public Collection<String> getSourceDependencies() {
        if (this.dependecyAnnotation == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(this.dependecyAnnotation.sources());
    }

    public Collection<JSTarget> getJSInterfaceDependencies() {
        if (this.dependecyAnnotation == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections2.transform(Arrays.asList(this.dependecyAnnotation.interfaces()), (Function)new Function<Class<?>, JSTarget>(){

            public JSTarget apply(Class<?> input) {
                return new JSTarget(input);
            }
        });
    }

    public JSMethod getJSMethod(String methodName, Object ... arguments) {
        Class[] types = new Class[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            types[i] = arguments.getClass();
        }
        try {
            Method method = this.jsInterface.getMethod(methodName, types);
            return new JSMethod(this, method);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean isInstallable() {
        return InstallableJavaScript.class.isAssignableFrom(this.jsInterface);
    }

    public ExecutionResolver getResolver() {
        return this.resolver;
    }

    private ExecutionResolver createResolver(JavaScript annotation) {
        try {
            if (annotation.methodResolver().equals(JavaScript.DefaultExecutionResolver.class)) {
                return (ExecutionResolver)Class.forName("org.jboss.arquillian.graphene.javascript.DefaultExecutionResolver").newInstance();
            }
            return annotation.methodResolver().newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("resolver " + annotation.methodResolver() + " can't be instantied", e);
        }
    }

    public String toString() {
        return "JSTarget [jsInterface=" + this.jsInterface.getName() + "]";
    }

    private Class<?> getImplementationOfInterface(Class<?> jsInterfaceClass) {
        JavaScript jsInterface = jsInterfaceClass.getAnnotation(JavaScript.class);
        if ("".equals(jsInterface.implementation())) {
            return jsInterfaceClass;
        }
        try {
            Class<?> implementationClazz = Class.forName(jsInterface.implementation());
            return implementationClazz;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot find class " + jsInterface.implementation() + ", make sure you have arquillian-graphene-impl.jar included on the classpath.", e);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

