/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.drone.factory;

import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.TypedWebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.WebDriverFactory;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.context.GrapheneProxy;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrapheneWebDriverFactory
extends WebDriverFactory
implements Configurator<WebDriver, TypedWebDriverConfiguration<WebDriverConfiguration>>,
Instantiator<WebDriver, TypedWebDriverConfiguration<WebDriverConfiguration>>,
Destructor<WebDriver> {
    public int getPrecedence() {
        return 20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyInstance(WebDriver instance) {
        try {
            super.destroyInstance(instance);
        }
        finally {
            GrapheneContext.reset();
        }
    }

    public WebDriver createInstance(TypedWebDriverConfiguration<WebDriverConfiguration> configuration) {
        WebDriver driver = super.createInstance(configuration);
        if (GrapheneProxy.isProxyInstance((WebDriver)driver)) {
            return driver;
        }
        WebDriver proxy = GrapheneContext.getProxyForDriver(WebDriver.class);
        GrapheneContext.set((WebDriver)driver);
        return proxy;
    }
}

