/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.configuration;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.graphene.configuration.GrapheneConfiguration;
import org.jboss.arquillian.graphene.configuration.GrapheneConfigurator;
import org.jboss.arquillian.graphene.context.GrapheneConfigurationContext;
import org.jboss.arquillian.graphene.spi.configuration.GrapheneConfigured;
import org.jboss.arquillian.graphene.spi.configuration.GrapheneUnconfigured;
import org.jboss.arquillian.test.spi.annotation.SuiteScoped;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.jboss.arquillian.test.test.AbstractTestTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=MockitoJUnitRunner.class)
public class ConfigurationContextTestCase
extends AbstractTestTestBase {
    @Mock
    private ArquillianDescriptor descriptor;
    @Mock
    private ExtensionDef extensionDefinition;

    @Before
    public void prepareDescriptor() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("waitGuiInterval", "5");
        properties.put("waitAjaxInterval", "25");
        properties.put("waitModelInterval", "125");
        Mockito.when((Object)this.extensionDefinition.getExtensionName()).thenReturn((Object)"graphene");
        Mockito.when((Object)this.extensionDefinition.getExtensionProperties()).thenReturn(properties);
        Mockito.when((Object)this.descriptor.getExtensions()).thenReturn(Arrays.asList(this.extensionDefinition));
    }

    @Test
    public void testConfigurationViaDescriptor() {
        this.getManager().bind(SuiteScoped.class, ArquillianDescriptor.class, (Object)this.descriptor);
        this.fire(new BeforeClass(Object.class));
        this.assertEventFired(GrapheneConfigured.class);
        Assert.assertNotNull((String)"Configuration instance has to be available.", (Object)GrapheneConfigurationContext.getProxy());
        GrapheneConfigurationContext.getProxy().validate();
        Assert.assertEquals((String)"'waitGuiInterval' should be 5", (long)5L, (long)GrapheneConfigurationContext.getProxy().getWaitGuiInterval());
        Assert.assertEquals((String)"'waitAjaxInterval' should be 25", (long)25L, (long)GrapheneConfigurationContext.getProxy().getWaitAjaxInterval());
        Assert.assertEquals((String)"'waitModelInterval' should be 125", (long)125L, (long)GrapheneConfigurationContext.getProxy().getWaitModelInterval());
        this.fire(new AfterClass(Object.class));
        this.assertEventFired(GrapheneUnconfigured.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfigurationViaSystemProperties() {
        try {
            this.getManager().bind(SuiteScoped.class, ArquillianDescriptor.class, (Object)this.descriptor);
            Assert.assertNotNull((Object)this.getManager().resolve(ArquillianDescriptor.class));
            System.setProperty("arquillian.graphene.wait.gui.interval", "10");
            System.setProperty("arquillian.graphene.wait.ajax.interval", "100");
            System.setProperty("arquillian.graphene.wait.model.interval", "1000");
            this.fire(new BeforeClass(Object.class));
            this.assertEventFired(GrapheneConfigured.class);
            Assert.assertNotNull((Object)this.getManager().resolve(GrapheneConfiguration.class));
            GrapheneConfigurationContext.getProxy().validate();
            Assert.assertEquals((String)"'waitGuiInterval' should be 10", (long)10L, (long)GrapheneConfigurationContext.getProxy().getWaitGuiInterval());
            Assert.assertEquals((String)"'waitAjaxInterval' should be 100", (long)100L, (long)GrapheneConfigurationContext.getProxy().getWaitAjaxInterval());
            Assert.assertEquals((String)"'waitModelInterval' should be 1000", (long)1000L, (long)GrapheneConfigurationContext.getProxy().getWaitModelInterval());
            this.fire(new AfterClass(Object.class));
            this.assertEventFired(GrapheneUnconfigured.class);
        }
        finally {
            System.clearProperty("arquillian.graphene.wait.gui.interval");
            System.clearProperty("arquillian.graphene.wait.ajax.interval");
            System.clearProperty("arquillian.graphene.wait.model.interval");
        }
    }

    protected void addExtensions(List<Class<?>> extensions) {
        extensions.add(GrapheneConfigurator.class);
    }
}

