/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.net.URL;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.enricher.AbstractPageFragmentStub;
import org.jboss.arquillian.graphene.enricher.page.TestPage;
import org.jboss.arquillian.graphene.spi.annotations.Page;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

@RunWith(value=Arquillian.class)
public class TestInitializingPageFragments {
    @FindBy(xpath="//div[@id='rootElement']")
    private AbstractPageFragmentStub abstractPageFragmentStub;
    @FindBy(xpath="//input")
    private WebElement input;
    @Page
    private TestPage testPage;
    private final String EXPECTED_NESTED_ELEMENT_TEXT = "Some Value";
    @Drone
    WebDriver selenium;

    public void loadPage() {
        URL page = this.getClass().getClassLoader().getResource("org/jboss/arquillian/graphene/ftest/pageFragmentsEnricher/sample.html");
        this.selenium.get(page.toExternalForm());
    }

    @Test
    public void testpageFragmentIsInitialized() {
        this.loadPage();
        Assert.assertNotNull((String)"AbstractPageFragment should be initialised at this point!", (Object)this.abstractPageFragmentStub);
    }

    @Test
    public void testPageFragmentHasSetRootCorrectly() {
        this.loadPage();
        Assert.assertEquals((String)"The root was not set correctly!", (Object)this.abstractPageFragmentStub.invokeMethodOnElementRefByXpath(), (Object)"Some Value");
    }

    @Test
    public void testPageObjectInitialisedCorrectly() {
        this.loadPage();
        Assert.assertEquals((String)"The page object was not set correctly!", (Object)this.testPage.getAbstractPageFragment().invokeMethodOnElementRefByXpath(), (Object)"Some Value");
    }

    @Test
    public void testOtherWebElementsInitialisedCorrectly() {
        this.loadPage();
        String EXPECTED_VALUE = "Gooseka";
        this.input.sendKeys(new CharSequence[]{EXPECTED_VALUE});
        Assert.assertEquals((String)"The value of the input is wrong, the element which represents it was not initialised correctly!", (Object)this.input.getAttribute("value"), (Object)EXPECTED_VALUE);
    }
}

