/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.guard;

import java.net.URL;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.guard.RequestGuardException;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.PageFactory;

@RunWith(value=Arquillian.class)
public class GuardsTestCase {
    @FindBy(id="http")
    private WebElement http;
    @FindBy(id="none")
    private WebElement none;
    @FindBy(id="xhr")
    private WebElement xhr;
    private Page page;
    @Drone
    private WebDriver browser;

    public void loadPage() {
        URL url = this.getClass().getClassLoader().getResource("org/jboss/arquillian/graphene/ftest/guard/sample1.html");
        this.browser.get(url.toString());
        this.page = new Page();
        PageFactory.initElements((WebDriver)this.browser, (Object)this.page);
    }

    @Test
    public void testGuardType() {
        Assert.assertTrue((boolean)(Graphene.guardXhr((Object)this.browser) instanceof WebDriver));
        Assert.assertTrue((boolean)(Graphene.guardHttp((Object)this.browser) instanceof WebDriver));
        Assert.assertTrue((boolean)(Graphene.guardNoRequest((Object)this.browser) instanceof WebDriver));
    }

    @Test
    public void testGuardHttp() {
        this.loadPage();
        ((WebElement)Graphene.guardHttp((Object)this.browser.findElement(By.id((String)"http")))).click();
    }

    @Test
    public void testGuardHttpInjectedByGraphene() {
        this.loadPage();
        ((WebElement)Graphene.guardHttp((Object)this.http)).click();
    }

    @Test
    public void testGuardHttpInjectedBySelenium() {
        this.loadPage();
        ((WebElement)Graphene.guardHttp((Object)this.page.http)).click();
    }

    @Test
    public void testGuardNoRequest() {
        this.loadPage();
        ((WebElement)Graphene.guardNoRequest((Object)this.browser.findElement(By.id((String)"none")))).click();
    }

    @Test
    public void testGuardNoRequestInjectedByGraphene() {
        this.loadPage();
        ((WebElement)Graphene.guardNoRequest((Object)this.none)).click();
    }

    @Test
    public void testGuardNoRequestInjectedBySelenium() {
        this.loadPage();
        ((WebElement)Graphene.guardNoRequest((Object)this.page.none)).click();
    }

    @Test
    public void testGuardXhr() {
        this.loadPage();
        ((WebElement)Graphene.guardXhr((Object)this.browser.findElement(By.id((String)"xhr")))).click();
    }

    @Test
    public void testGuardXhrInjectedByGraphene() {
        this.loadPage();
        ((WebElement)Graphene.guardXhr((Object)this.xhr)).click();
    }

    @Test
    public void testGuardXhrInjectedBySelenium() {
        this.loadPage();
        ((WebElement)Graphene.guardXhr((Object)this.page.xhr)).click();
    }

    @Test(expected=RequestGuardException.class)
    public void testGuardHttpFailure() {
        this.loadPage();
        ((WebElement)Graphene.guardHttp((Object)this.browser.findElement(By.id((String)"xhr")))).click();
    }

    @Test(expected=RequestGuardException.class)
    public void testGuardNoRequestFailure() {
        this.loadPage();
        ((WebElement)Graphene.guardNoRequest((Object)this.browser.findElement(By.id((String)"http")))).click();
    }

    @Test(expected=RequestGuardException.class)
    public void testGuardXhrFailure() {
        this.loadPage();
        ((WebElement)Graphene.guardXhr((Object)this.browser.findElement(By.id((String)"http")))).click();
    }

    private static class Page {
        @FindBy(id="http")
        private WebElement http;
        @FindBy(id="none")
        private WebElement none;
        @FindBy(id="xhr")
        private WebElement xhr;

        private Page() {
        }
    }
}

