/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.guard;

import java.net.URL;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.guard.RequestGuard;
import org.jboss.arquillian.graphene.javascript.JSInterfaceFactory;
import org.jboss.arquillian.graphene.page.RequestType;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

@RunWith(value=Arquillian.class)
public class RequestGuardTestCase {
    @Drone
    private WebDriver browser;

    public void loadPage() {
        URL page = this.getClass().getClassLoader().getResource("org/jboss/arquillian/graphene/ftest/guard/sample1.html");
        this.browser.get(page.toString());
    }

    @Test
    public void testXhr() throws InterruptedException {
        this.loadPage();
        RequestGuard guard = (RequestGuard)JSInterfaceFactory.create(RequestGuard.class);
        Assert.assertEquals((Object)RequestType.HTTP, (Object)guard.getRequestDone());
        guard.clearRequestDone();
        Assert.assertEquals((Object)RequestType.NONE, (Object)guard.getRequestDone());
        this.browser.findElement(By.id((String)"xhr")).click();
        Assert.assertEquals((Object)RequestType.XHR, (Object)guard.getRequestDone());
    }

    @Test
    public void testHttp() {
        this.loadPage();
        RequestGuard guard = (RequestGuard)JSInterfaceFactory.create(RequestGuard.class);
        Assert.assertEquals((Object)RequestType.HTTP, (Object)guard.getRequestDone());
        guard.clearRequestDone();
        Assert.assertEquals((Object)RequestType.NONE, (Object)guard.getRequestDone());
        this.browser.findElement(By.id((String)"http")).click();
        Assert.assertEquals((Object)RequestType.HTTP, (Object)guard.getRequestDone());
    }
}

