/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.javascript;

import java.net.URL;
import java.util.List;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.javascript.Dependency;
import org.jboss.arquillian.graphene.javascript.InstallableJavaScript;
import org.jboss.arquillian.graphene.javascript.JSInterfaceFactory;
import org.jboss.arquillian.graphene.javascript.JavaScript;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

@RunWith(value=Arquillian.class)
public class JavaScriptPageExtensionTestCase {
    @Drone
    private WebDriver browser;

    public void loadPage() {
        URL page = this.getClass().getClassLoader().getResource("org/jboss/arquillian/graphene/ftest/javascript/sample.html");
        this.browser.get(page.toString());
    }

    @Test
    public void testWithoutSources() {
        this.loadPage();
        Document document = (Document)JSInterfaceFactory.create(Document.class);
        List<WebElement> elements = document.getElementsByTagName("html");
        Assert.assertNotNull(elements);
        Assert.assertEquals((long)1L, (long)elements.size());
    }

    @Test
    public void testWithSources() {
        this.loadPage();
        HelloWorld helloWorld = (HelloWorld)JSInterfaceFactory.create(HelloWorld.class);
        Assert.assertEquals((Object)"Hello World!", (Object)helloWorld.hello());
    }

    @Test
    public void testWithInterfaceDependencies() {
        this.loadPage();
        HelloWorld2 helloWorld = (HelloWorld2)JSInterfaceFactory.create(HelloWorld2.class);
        Assert.assertEquals((Object)"Hello World!", (Object)helloWorld.hello());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWithoutSourceAndWithInterfaceDependencies() {
        this.loadPage();
        ((Document2)JSInterfaceFactory.create(Document2.class)).getTitle();
    }

    @JavaScript(value="Document.helloworld2")
    @Dependency(sources={"org/jboss/arquillian/graphene/ftest/javascript/hello-world2.js"}, interfaces={HelloWorld.class})
    private static interface HelloWorld2 {
        public String hello();
    }

    @JavaScript(value="Document.helloworld")
    @Dependency(sources={"org/jboss/arquillian/graphene/ftest/javascript/hello-world.js"})
    private static interface HelloWorld
    extends InstallableJavaScript {
        public String hello();
    }

    @JavaScript(value="fake")
    @Dependency(interfaces={HelloWorld.class})
    public static interface Document2 {
        public String getTitle();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JavaScript(value="document")
    public static interface Document {
        public String getTitle();

        public List<WebElement> getElementsByTagName(String var1);
    }
}

