/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.page.extension;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import junit.framework.Assert;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.context.GraphenePageExtensionsContext;
import org.jboss.arquillian.graphene.page.extension.PageExtensionRegistry;
import org.jboss.arquillian.graphene.spi.javascript.JavaScript;
import org.jboss.arquillian.graphene.spi.page.PageExtension;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.openqa.selenium.WebDriver;

@RunWith(value=Arquillian.class)
public class PageExtensionTestCase {
    @Drone
    private WebDriver browser;

    public void loadPage() {
        URL page = this.getClass().getClassLoader().getResource("org/jboss/arquillian/graphene/ftest/page/extension/sample.html");
        this.browser.get(page.toString());
    }

    @Test
    public void testCorrectInstallation() {
        this.loadPage();
        PageExtension pageExtensionMock = (PageExtension)Mockito.mock(PageExtension.class);
        Mockito.when((Object)pageExtensionMock.getExtensionScript()).thenReturn((Object)JavaScript.fromString((String)"Document.Graphene = {};"));
        Mockito.when((Object)pageExtensionMock.getInstallationDetectionScript()).thenReturn((Object)JavaScript.fromString((String)"return (typeof Document.Graphene != 'undefined');"));
        Mockito.when((Object)pageExtensionMock.getRequired()).thenReturn((Object)Collections.EMPTY_LIST);
        PageExtensionRegistry registry = GraphenePageExtensionsContext.getRegistryProxy();
        registry.register(new PageExtension[]{pageExtensionMock});
        GraphenePageExtensionsContext.getInstallatorProviderProxy().installator(pageExtensionMock.getName()).install();
    }

    @Test(expected=IllegalStateException.class)
    public void testIncorrectInstallation() {
        this.loadPage();
        PageExtension pageExtensionMock = (PageExtension)Mockito.mock(PageExtension.class);
        Mockito.when((Object)pageExtensionMock.getExtensionScript()).thenReturn((Object)JavaScript.fromString((String)"var Graphene = {};"));
        Mockito.when((Object)pageExtensionMock.getInstallationDetectionScript()).thenReturn((Object)JavaScript.fromString((String)"return (typeof Graphene != 'undefined');"));
        Mockito.when((Object)pageExtensionMock.getRequired()).thenReturn((Object)Collections.EMPTY_LIST);
        PageExtensionRegistry registry = GraphenePageExtensionsContext.getRegistryProxy();
        registry.register(new PageExtension[]{pageExtensionMock});
        GraphenePageExtensionsContext.getInstallatorProviderProxy().installator(pageExtensionMock.getName()).install();
    }

    @Test
    public void testInstallationWithRequirements() {
        this.loadPage();
        PageExtension pageExtensionMock = (PageExtension)Mockito.mock(PageExtension.class);
        Mockito.when((Object)pageExtensionMock.getExtensionScript()).thenReturn((Object)JavaScript.fromString((String)"Document.Graphene2 = Document.Graphene1 + 1;"));
        Mockito.when((Object)pageExtensionMock.getInstallationDetectionScript()).thenReturn((Object)JavaScript.fromString((String)"return ((typeof Document.Graphene2 != 'undefined') && Document.Graphene2 == 2);"));
        ArrayList<String> requirements = new ArrayList<String>();
        requirements.add(SimplePageExtension.class.getName());
        Mockito.when((Object)pageExtensionMock.getRequired()).thenReturn(requirements);
        PageExtensionRegistry registry = GraphenePageExtensionsContext.getRegistryProxy();
        registry.register(new PageExtension[]{new SimplePageExtension()});
        registry.register(new PageExtension[]{pageExtensionMock});
        GraphenePageExtensionsContext.getInstallatorProviderProxy().installator(pageExtensionMock.getName()).install();
        Assert.assertTrue((boolean)GraphenePageExtensionsContext.getInstallatorProviderProxy().installator(SimplePageExtension.class.getName()).isInstalled());
        Assert.assertTrue((boolean)GraphenePageExtensionsContext.getInstallatorProviderProxy().installator(pageExtensionMock.getName()).isInstalled());
    }

    @Test(expected=IllegalStateException.class)
    public void testInstallationWithCyclicRequirements() {
        this.loadPage();
        PageExtension pageExtensionMock = (PageExtension)Mockito.mock(PageExtension.class);
        Mockito.when((Object)pageExtensionMock.getExtensionScript()).thenReturn((Object)JavaScript.fromString((String)"Document.Graphene2 = Document.Graphene1 + 1;"));
        Mockito.when((Object)pageExtensionMock.getInstallationDetectionScript()).thenReturn((Object)JavaScript.fromString((String)"return ((typeof Document.Graphene2 != 'undefined') && Document.Graphene2 == 2);"));
        ArrayList<String> requirements = new ArrayList<String>();
        requirements.add(SimplePageExtension.class.getName());
        requirements.add(CyclicPageExtension1.class.getName());
        requirements.add(CyclicPageExtension2.class.getName());
        Mockito.when((Object)pageExtensionMock.getRequired()).thenReturn(requirements);
        PageExtensionRegistry registry = GraphenePageExtensionsContext.getRegistryProxy();
        registry.register(new PageExtension[]{new SimplePageExtension()});
        registry.register(new PageExtension[]{pageExtensionMock});
        registry.register(new PageExtension[]{new CyclicPageExtension1()});
        registry.register(new PageExtension[]{new CyclicPageExtension2()});
        GraphenePageExtensionsContext.getInstallatorProviderProxy().installator(pageExtensionMock.getName()).install();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CyclicPageExtension2
    implements PageExtension {
        private CyclicPageExtension2() {
        }

        public JavaScript getExtensionScript() {
            return JavaScript.fromString((String)"Document.Cyclic2 = 1;");
        }

        public JavaScript getInstallationDetectionScript() {
            return JavaScript.fromString((String)"return ((typeof Document.Cyclic2 != 'undefined') && Document.Cyclic2 == 1);");
        }

        public Collection<String> getRequired() {
            ArrayList<String> required = new ArrayList<String>();
            required.add(CyclicPageExtension1.class.getName());
            return required;
        }

        public String getName() {
            return this.getClass().getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CyclicPageExtension1
    implements PageExtension {
        private CyclicPageExtension1() {
        }

        public JavaScript getExtensionScript() {
            return JavaScript.fromString((String)"Document.Cyclic1 = 1;");
        }

        public JavaScript getInstallationDetectionScript() {
            return JavaScript.fromString((String)"return ((typeof Document.Cyclic1 != 'undefined') && Document.Cyclic1 == 1);");
        }

        public Collection<String> getRequired() {
            ArrayList<String> required = new ArrayList<String>();
            required.add(CyclicPageExtension2.class.getName());
            return required;
        }

        public String getName() {
            return this.getClass().getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimplePageExtension
    implements PageExtension {
        private SimplePageExtension() {
        }

        public JavaScript getExtensionScript() {
            return JavaScript.fromString((String)"Document.Graphene1 = 1;");
        }

        public JavaScript getInstallationDetectionScript() {
            return JavaScript.fromString((String)"return ((typeof Document.Graphene1 != 'undefined') && Document.Graphene1 == 1);");
        }

        public Collection<String> getRequired() {
            return Collections.EMPTY_LIST;
        }

        public String getName() {
            return this.getClass().getName();
        }
    }
}

