/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.net.URL;
import java.util.List;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.spi.annotations.Root;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

@RunWith(value=Arquillian.class)
public class TestHandlingOfStaleElements {
    @Drone
    private WebDriver browser;
    @ArquillianResource
    private JavascriptExecutor executor;
    @FindBy(id="root")
    private StaleElementPageFragment pageFragment;
    @FindBy(id="root")
    private List<StaleElementPageFragment> pageFragments;
    @FindBy(id="root")
    private WebElement rootElement;
    @FindBy(id="root")
    private List<WebElement> rootElements;
    @FindBy(tagName="body")
    private WebElement body;

    @Before
    public void loadPage() {
        URL page = this.getClass().getClassLoader().getResource("org/jboss/arquillian/graphene/ftest/enricher/staleelements.html");
        this.browser.get(page.toString());
    }

    @Test
    public void testDeletion() {
        this.rootElement.isDisplayed();
        this.executor.executeScript("return arguments[0].parentNode.removeChild(arguments[0])", new Object[]{this.rootElement});
        try {
            this.rootElement.isDisplayed();
            Assert.fail((String)"rootElement should not be found");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testReplacement() {
        this.rootElement.isDisplayed();
        this.executor.executeScript("return arguments[0].parentNode.removeChild(arguments[0])", new Object[]{this.rootElement});
        try {
            this.rootElement.isDisplayed();
            Assert.fail((String)"rootElement should not be found");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testElement() throws Exception {
        this.rootElement.isDisplayed();
        this.pageFragment.makeStale();
        this.rootElement.isDisplayed();
    }

    @Test
    public void testListOfElements() throws Exception {
        WebElement e = this.rootElements.get(0);
        e.isDisplayed();
        this.pageFragment.makeStale();
        e.isDisplayed();
    }

    @Test
    public void testPageFragment() throws Exception {
        this.pageFragment.root.isDisplayed();
        this.pageFragment.makeStale();
        this.pageFragment.root.isDisplayed();
    }

    @Test
    public void testListOfPageFragments() throws Exception {
        StaleElementPageFragment pf = this.pageFragments.get(0);
        pf.root.isDisplayed();
        pf.makeStale();
        pf.root.isDisplayed();
    }

    public static class StaleElementPageFragment {
        @Root
        private WebElement root;
        @FindBy(className="stale")
        private WebElement stale;
        @FindBy(className="make-stale")
        private WebElement makeStale;

        public void makeStale() {
            this.makeStale.click();
        }
    }
}

