/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.net.URL;
import java.util.List;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.spi.annotations.Page;
import org.jboss.arquillian.graphene.spi.annotations.Root;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Arquillian.class)
public class TestPageFragmentList {
    @Drone
    private WebDriver browser;
    @FindBy(id="root")
    private RootPageFragment root;
    @FindBy(css="#root span")
    private List<ChildPageFragment> children;
    @FindBy(id="root")
    private List<RootPageFragment> roots;
    @Page
    private PageWithChildren page;

    public void loadPage() {
        URL page = this.getClass().getClassLoader().getResource("org/jboss/arquillian/graphene/ftest/enricher/morepagefragments.html");
        this.browser.get(page.toString());
    }

    @Test
    public void testInClass() {
        this.loadPage();
        this.checkChildren(this.children);
    }

    @Test
    public void testInListOfPageFragments() {
        this.loadPage();
        this.checkChildren(this.roots.get(0).getChildren());
    }

    @Test
    public void testInPage() {
        this.loadPage();
        this.checkChildren(this.page.getChildren());
    }

    @Test
    public void testInPageFragment() {
        this.loadPage();
        this.checkChildren(this.root.getChildren());
    }

    protected void checkChildren(List<ChildPageFragment> childPageFragments) {
        Assert.assertEquals((String)"Number of child page fragments doesn't match.", (long)4L, (long)childPageFragments.size());
        int index = 0;
        for (ChildPageFragment child : childPageFragments) {
            Assert.assertEquals((String)("Inner text of child page fragment <" + ++index + "> doesn't match"), (Object)Integer.toString(index), (Object)child.getText());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PageWithChildren {
        @FindBy(css="#root span")
        private List<ChildPageFragment> children;

        public List<ChildPageFragment> getChildren() {
            return this.children;
        }
    }

    public static class ChildPageFragment {
        @Root
        private WebElement root;

        public String getText() {
            return this.root.getText().trim();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RootPageFragment {
        @Root
        private WebElement root;
        @FindBy(tagName="span")
        private List<ChildPageFragment> children;

        public List<ChildPageFragment> getChildren() {
            return this.children;
        }
    }
}

