/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.net.URL;
import junit.framework.Assert;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.spi.annotations.Root;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

@RunWith(value=Arquillian.class)
public class TestSamplePageFragment {
    @Drone
    private WebDriver browser;
    @FindBy(id="root")
    private SamplePageFragment pageFragment;
    @FindBy(id="root")
    private SamplePageFragmentWithRootAsTheLastField pageFragmentWithRootAsTheLastField;
    @FindBy(id="span")
    private WebElement spanNotCorrect;

    public void loadPage() {
        URL page = this.getClass().getClassLoader().getResource("org/jboss/arquillian/graphene/ftest/enricher/sample.html");
        this.browser.get(page.toString());
    }

    @Test
    public void testRelativePath() {
        this.loadPage();
        Assert.assertEquals((String)"Fields in page fragment are not initialized relatively to root element.", (String)"correct", (String)this.pageFragment.getText().toLowerCase().trim());
    }

    @Test
    public void testNotStandardOrder() {
        this.loadPage();
        Assert.assertEquals((String)"pseudo root", (String)this.pageFragmentWithRootAsTheLastField.getPseudoroot().getText().toLowerCase().trim());
        Assert.assertTrue((boolean)this.pageFragmentWithRootAsTheLastField.getRoot().getText().toLowerCase().trim().contains("pseudo root"));
        Assert.assertFalse((boolean)this.pageFragmentWithRootAsTheLastField.getRoot().getText().toLowerCase().trim().equals("pseudo root"));
    }

    public void testCommonWebElement() {
        this.loadPage();
        Assert.assertEquals((String)"not correct", (String)this.spanNotCorrect.getText().toLowerCase().trim());
    }

    public static class SamplePageFragmentWithRootAsTheLastField {
        @FindBy(id="pseudoroot")
        private WebElement pseudoroot;
        @Root
        private WebElement root;

        public WebElement getRoot() {
            return this.root;
        }

        public WebElement getPseudoroot() {
            return this.pseudoroot;
        }
    }

    public static class SamplePageFragment {
        @Root
        private WebElement root;
        @FindBy(tagName="span")
        private WebElement span;

        public String getText() {
            return this.span.getText();
        }
    }
}

