/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.enricher.selenium;

import java.net.URL;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.enricher.findby.FindBy;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Mouse;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.internal.Locatable;

@RunWith(value=Arquillian.class)
public class TestSeleniumResourceProvider {
    @Drone
    private WebDriver browser;
    @FindBy(css="input[type=button]")
    WebElement button;

    @Before
    public void loadPage() {
        URL url = this.getClass().getClassLoader().getResource("org/jboss/arquillian/graphene/ftest/enricher/selenium-provider.html");
        this.browser.get(url.toString());
    }

    @Test
    public void testWebDriver(@ArquillianResource WebDriver driver) {
        Assert.assertEquals((Object)"Sample Page", (Object)driver.getTitle());
    }

    @Test
    public void testJavaScriptExecutor(@ArquillianResource JavascriptExecutor executor) {
        executor.executeScript("document.title = arguments[0]", new Object[]{"New Title"});
        Assert.assertEquals((Object)"New Title", (Object)this.browser.getTitle());
    }

    @Test
    public void testMouse(@ArquillianResource Mouse mouse) {
        mouse.click(((Locatable)this.button).getCoordinates());
        Assert.assertEquals((Object)"Clicked", (Object)this.button.getAttribute("value"));
    }

    @Test
    public void testActions(@ArquillianResource Actions actions) {
        actions.click(this.button).perform();
        Assert.assertEquals((Object)"Clicked", (Object)this.button.getAttribute("value"));
    }
}

