/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.guard;

import java.net.URL;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.guard.RequestGuardException;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

@RunWith(value=Arquillian.class)
public class GuardsTestCase {
    @FindBy(id="http")
    private WebElement http;
    @FindBy(id="none")
    private WebElement none;
    @FindBy(id="xhr")
    private WebElement xhr;
    @FindBy(id="xhr-delayed-trigerring")
    private WebElement xhrDelayedTrigerring;
    @FindBy(id="xhr-delayed-processing")
    private WebElement xhrDelayedProcessing;
    @FindBy(id="xhr-delayed-processing-with-code-arg")
    private WebElement xhrDelayedProcessingWithCodeArgument;
    @FindBy(id="status")
    private WebElement status;
    @Drone
    private WebDriver browser;

    @Before
    public void loadPage() {
        URL url = this.getClass().getClassLoader().getResource("org/jboss/arquillian/graphene/ftest/guard/sample1.html");
        this.browser.get(url.toString());
    }

    @Test
    public void testGuardType() {
        Assert.assertTrue((boolean)(Graphene.guardXhr((Object)this.browser) instanceof WebDriver));
        Assert.assertTrue((boolean)(Graphene.guardHttp((Object)this.browser) instanceof WebDriver));
        Assert.assertTrue((boolean)(Graphene.guardNoRequest((Object)this.browser) instanceof WebDriver));
    }

    @Test
    public void testGuardHttp() {
        ((WebElement)Graphene.guardHttp((Object)this.http)).click();
    }

    @Test
    public void testGuardNoRequest() {
        ((WebElement)Graphene.guardNoRequest((Object)this.none)).click();
    }

    @Test
    public void testGuardXhr() {
        ((WebElement)Graphene.guardXhr((Object)this.xhr)).click();
        Assert.assertTrue((boolean)this.status.getText().contains("DONE"));
    }

    @Test
    public void testGuardDelayedXhr() {
        ((WebElement)Graphene.guardXhr((Object)this.xhrDelayedTrigerring)).click();
        Assert.assertTrue((boolean)this.status.getText().contains("DONE"));
    }

    @Test
    public void testGuardDelayedXhrProcessing() {
        ((WebElement)Graphene.guardXhr((Object)this.xhrDelayedProcessing)).click();
        Assert.assertTrue((boolean)this.status.getText().contains("DONE"));
    }

    @Test
    public void testGuardDelayedXhrProcessingWithCodeArgument() {
        ((WebElement)Graphene.guardXhr((Object)this.xhrDelayedProcessingWithCodeArgument)).click();
        Assert.assertTrue((boolean)this.status.getText().contains("DONE"));
    }

    @Test(expected=RequestGuardException.class)
    public void testGuardHttpFailure() {
        ((WebElement)Graphene.guardHttp((Object)this.xhr)).click();
    }

    @Test(expected=RequestGuardException.class)
    public void testGuardNoRequestFailure() {
        ((WebElement)Graphene.guardNoRequest((Object)this.http)).click();
    }

    @Test(expected=RequestGuardException.class)
    public void testGuardXhrFailure() {
        ((WebElement)Graphene.guardXhr((Object)this.http)).click();
    }

    @Test(expected=RequestGuardException.class)
    public void testDelayedGuardNoRequest() {
        ((WebElement)Graphene.guardNoRequest((Object)this.xhrDelayedTrigerring)).click();
    }
}

