/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.guard;

import java.net.URL;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.guard.RequestGuard;
import org.jboss.arquillian.graphene.javascript.JSInterfaceFactory;
import org.jboss.arquillian.graphene.page.RequestType;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

@RunWith(value=Arquillian.class)
public class RequestGuardTestCase {
    @Drone
    private WebDriver browser;
    @FindBy(id="xhr")
    private WebElement xhr;
    @FindBy(id="http")
    private WebElement http;
    @FindBy(id="status")
    private WebElement status;

    @Before
    public void loadPage() {
        URL page = this.getClass().getClassLoader().getResource("org/jboss/arquillian/graphene/ftest/guard/sample1.html");
        this.browser.get(page.toString());
    }

    @Test
    public void testXhr() throws InterruptedException {
        RequestGuard guard = (RequestGuard)JSInterfaceFactory.create(RequestGuard.class);
        Assert.assertEquals((Object)RequestType.HTTP, (Object)guard.getRequestDone());
        guard.clearRequestDone();
        Assert.assertEquals((Object)RequestType.NONE, (Object)guard.getRequestDone());
        this.xhr.click();
        Graphene.waitAjax().until().element(this.status).text().contains("DONE");
        Assert.assertEquals((Object)RequestType.XHR, (Object)guard.getRequestDone());
    }

    @Test
    public void testHttp() {
        RequestGuard guard = (RequestGuard)JSInterfaceFactory.create(RequestGuard.class);
        Assert.assertEquals((Object)RequestType.HTTP, (Object)guard.getRequestDone());
        guard.clearRequestDone();
        Assert.assertEquals((Object)RequestType.NONE, (Object)guard.getRequestDone());
        this.http.click();
        Assert.assertEquals((Object)RequestType.HTTP, (Object)guard.getRequestDone());
    }
}

