/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.page.extension;

import java.net.URL;
import java.util.List;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.enricher.findby.ByJQuery;
import org.jboss.arquillian.graphene.enricher.findby.FindBy;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

@RunWith(value=Arquillian.class)
public class JQuerySelectorsPageExtensionTestCase {
    @FindBy(jquery=":header")
    private WebElement webElementByJQuery;
    @FindBy(jquery=":header")
    private List<WebElement> listOfWebElementsByJQuery;
    @FindBy(jquery="div:eq(1)")
    private JQuerySelectorTestPageFragment jquerySelectorTestPageFragment;
    @FindBy(jquery="div:eq(1)")
    private List<JQuerySelectorTestPageFragment> listOfJQueryPageFragments;
    @FindBy(jquery="#nonExistingId")
    private WebElement notExistingElement;
    @FindBy(jquery="#nonExistingId")
    private List<WebElement> notExistingElements;
    private static final String contentOfSpecialCharacters = "special chars '\"$";
    @FindBy(jquery="p:contains(\"special chars '\"$\")")
    private WebElement escapedDoubleQuotes;
    @FindBy(jquery="div[id=\"foo:bar\"]")
    private WebElement escapedDoubleQuotes2;
    @Drone
    private WebDriver browser;
    private static final String EXPECTED_JQUERY_TEXT_1 = "Hello jquery selectors!";
    private static final String EXPECTED_JQUERY_TEXT_2 = "Nested div with foo class.";
    private static final String EXPECTED_NO_SUCH_EL_EX_MSG = "Cannot locate element using";
    private static final String EXPECTED_WRONG_SELECTOR_MSG = "Check out whether it is correct!";

    public void loadPage() {
        URL page = this.getClass().getClassLoader().getResource("org/jboss/arquillian/graphene/ftest/page/extension/sampleJQueryLocator.html");
        this.browser.get(page.toString());
    }

    @Test
    public void testFindByWrongSelector() {
        this.loadPage();
        WebElement element = null;
        try {
            element = this.browser.findElement((By)ByJQuery.jquerySelector((String)":notExistingSelector"));
        }
        catch (WebDriverException ex) {
            Assert.assertTrue((String)"The exception thrown after locating element by non existing selector is wrong!", (boolean)ex.getMessage().contains(EXPECTED_WRONG_SELECTOR_MSG));
            return;
        }
        Assert.fail((String)"There should be webdriver exception thrown when locating element by wrong selector!");
    }

    @Test
    public void testFindNonExistingElement() {
        this.loadPage();
        try {
            WebElement nonExistingElement = this.browser.findElement((By)ByJQuery.jquerySelector((String)":contains('non existing string')"));
        }
        catch (NoSuchElementException ex) {
            Assert.assertTrue((String)"Error message of NoSuchElementException is wrong!", (boolean)ex.getMessage().contains(EXPECTED_NO_SUCH_EL_EX_MSG));
            return;
        }
        Assert.fail((String)"There was not thrown NoSuchElementException when trying to locate non existed element!");
    }

    @Test
    public void testFindingWebElementFromAnotherWebElement() {
        this.loadPage();
        WebElement root = this.browser.findElement((By)ByJQuery.jquerySelector((String)"#root:visible"));
        WebElement div = root.findElement((By)ByJQuery.jquerySelector((String)".foo:visible"));
        Assert.assertNotNull((String)"The div element should be found!", (Object)div);
        Assert.assertEquals((String)"The element was not referenced from parent WebElement correctly!", (Object)EXPECTED_JQUERY_TEXT_2, (Object)div.getText());
    }

    @Test
    public void testJQuerySelectorCallingFindByDirectly() {
        this.loadPage();
        ByJQuery headerBy = new ByJQuery(":header");
        WebElement headerElement = this.browser.findElement((By)headerBy);
        Assert.assertNotNull((Object)headerElement);
        Assert.assertEquals((Object)"h1", (Object)headerElement.getTagName());
    }

    @Test
    public void testFindByOnWebElement() {
        this.loadPage();
        Assert.assertNotNull((Object)this.webElementByJQuery);
        Assert.assertEquals((Object)"h1", (Object)this.webElementByJQuery.getTagName());
    }

    @Test
    public void testFindByOnListOfWebElement() {
        this.loadPage();
        Assert.assertNotNull(this.listOfWebElementsByJQuery);
        Assert.assertEquals((Object)"h1", (Object)this.listOfWebElementsByJQuery.get(0).getTagName());
    }

    @Test
    public void testFindByOnPageFragment() {
        this.loadPage();
        Assert.assertNotNull((Object)this.jquerySelectorTestPageFragment);
        Assert.assertEquals((Object)EXPECTED_JQUERY_TEXT_1, (Object)this.jquerySelectorTestPageFragment.getJQueryLocator().getText());
    }

    @Test
    public void testFindByOnListOfPageFragments() {
        this.loadPage();
        Assert.assertNotNull(this.listOfJQueryPageFragments);
        Assert.assertEquals((Object)EXPECTED_JQUERY_TEXT_1, (Object)this.listOfJQueryPageFragments.get(0).getJQueryLocator().getText());
    }

    @Test(expected=NoSuchElementException.class)
    public void testFindNotExistingWebElement() {
        this.loadPage();
        String text = this.notExistingElement.getText();
    }

    @Test
    public void testFindNonExistingWebElements() {
        this.loadPage();
        Assert.assertEquals((String)"When locating not existing elements an empty list should be returned!", (long)0L, (long)this.notExistingElements.size());
    }

    @Test
    public void testEscapedDoubleQuotesSelector() {
        this.loadPage();
        String actual = this.escapedDoubleQuotes.getText().trim();
        Assert.assertEquals((String)"WebElement referenced by ecaped locator was not found correctly!", (Object)contentOfSpecialCharacters, (Object)actual);
    }

    @Test
    public void testEscapedColonSelector() {
        this.loadPage();
        String actual = this.escapedDoubleQuotes2.getText().trim();
        Assert.assertEquals((String)"WebElement with locator containing escaped colon not located correctly!", (Object)"Some content", (Object)actual);
    }

    public class JQuerySelectorTestPageFragment {
        @FindBy(jquery="div:contains('jquery selectors')")
        private WebElement jqueryLocator;

        public WebElement getJQueryLocator() {
            return this.jqueryLocator;
        }
    }
}

