/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.net.URL;
import junit.framework.Assert;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.spi.annotations.Page;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

@RunWith(value=Arquillian.class)
public class TestDroneIntegrationWhenDroneIsUsedInTest {
    @Drone
    private WebDriver browser;
    @Page
    private DronePage page;
    @FindBy(id="root")
    private DronePageFragment pageFragment;

    public void loadPage(WebDriver browser) {
        URL url = this.getClass().getClassLoader().getResource("org/jboss/arquillian/graphene/ftest/enricher/sample.html");
        browser.get(url.toString());
    }

    @Test
    public void testDronePageNotNull() {
        Assert.assertNotNull((Object)this.page.browser);
    }

    @Test
    public void testDronePageFragmentNotNull() {
        Assert.assertNotNull((Object)this.pageFragment.browser);
    }

    @Test
    public void testDronePageTitle() {
        this.loadPage(this.page.browser);
        Assert.assertEquals((String)"Sample Page", (String)this.page.browser.getTitle());
    }

    @Test
    public void testDronePageFragmentTitle() {
        this.loadPage(this.pageFragment.browser);
        Assert.assertEquals((String)"Sample Page", (String)this.pageFragment.browser.getTitle());
    }

    public static class DronePageFragment {
        @Drone
        private WebDriver browser;
        @FindBy(tagName="span")
        private WebElement span;
    }

    public static class DronePage {
        @Drone
        private WebDriver browser;
    }
}

