/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.net.URL;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.enricher.findby.FindBy;
import org.jboss.arquillian.graphene.enricher.page.fragment.Panel;
import org.jboss.arquillian.graphene.enricher.page.fragment.TabPanel;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

@RunWith(value=Arquillian.class)
public class TestEnrichingContainerElement {
    @Drone
    private WebDriver browser;
    @FindBy(className="tabpanel")
    private TabPanel tabPanel;

    @Before
    public void loadPage() {
        URL page = this.getClass().getClassLoader().getResource("org/jboss/arquillian/graphene/ftest/enricher/container-elements.html");
        this.browser.get(page.toString());
    }

    @Test
    public void testTabPanelSwitching() {
        Panel tab3 = this.tabPanel.switchTo(2);
        ContentOfTab content = tab3.getContent(ContentOfTab.class);
        Assert.assertEquals((String)"The tab panel was not switched to third tab correctly!", (Object)"Content of the tab 3", (Object)content.text.getText());
        Panel tab1 = this.tabPanel.switchTo(0);
        content = tab1.getContent(ContentOfTab.class);
        Assert.assertEquals((String)"The tab panel was not switched to first tab correctly!", (Object)"Content of the tab 1", (Object)content.text.getText());
    }

    private static class ContentOfTab {
        @FindBy(className="tab-text")
        public WebElement text;

        private ContentOfTab() {
        }
    }
}

