/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.net.URL;
import java.util.List;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.enricher.findby.FindBy;
import org.jboss.arquillian.graphene.enricher.findby.FindBys;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Arquillian.class)
public class TestInitializeFindBys {
    @Drone
    private WebDriver browser;
    private static final String EXPECTED = "correct";
    @org.openqa.selenium.support.FindBys(value={@org.openqa.selenium.support.FindBy(css="#root"), @org.openqa.selenium.support.FindBy(tagName="div"), @org.openqa.selenium.support.FindBy(tagName="span")})
    private WebElement element;
    @FindBys(value={@FindBy(css="#root"), @FindBy(tagName="div"), @FindBy(tagName="span")})
    private WebElement element2;
    @org.openqa.selenium.support.FindBys(value={@org.openqa.selenium.support.FindBy(css="#root"), @org.openqa.selenium.support.FindBy(css=".list")})
    private List<WebElement> elements;
    @FindBys(value={@FindBy(css="#root"), @FindBy(css=".list")})
    private List<WebElement> elements2;

    @Before
    public void loadPage() {
        URL page = this.getClass().getClassLoader().getResource("org/jboss/arquillian/graphene/ftest/enricher/findbys.html");
        this.browser.get(page.toString());
    }

    @Test
    public void testWebDriverFindBysOverWebElementInitialized() {
        this.assertFindBysOverWebElement(this.element);
    }

    @Test
    public void testGrapheneFindBysOverWebElementInitialized() {
        this.assertFindBysOverWebElement(this.element2);
    }

    private void assertFindBysOverWebElement(WebElement element) {
        Assert.assertNotNull((String)"Element cannot be null! @FindBys was not initialized correctly!", (Object)element);
        Assert.assertEquals((String)"Element location determined by @FindBys was not correct!", (Object)EXPECTED, (Object)element.getText());
    }

    @Test
    public void testWebDriverFindBysOverListInitialized() {
        this.assertFindBysOverList(this.elements);
    }

    @Test
    public void testGrapheneFindBysOverListInitialized() {
        this.assertFindBysOverList(this.elements2);
    }

    private void assertFindBysOverList(List<WebElement> elements) {
        Assert.assertNotNull(elements);
        for (int i = 1; i < 4; ++i) {
            Assert.assertEquals((long)i, (long)Integer.valueOf(elements.get(i - 1).getText()).intValue());
        }
    }
}

