/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.net.URL;
import java.util.List;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.enricher.fragment.AbstractPageFragmentStub;
import org.jboss.arquillian.graphene.enricher.page.TestPage;
import org.jboss.arquillian.graphene.enricher.page.fragment.PageFragmentWithEmbeddedAnotherPageFragmentStub;
import org.jboss.arquillian.graphene.spi.annotations.Page;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.HasInputDevices;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.FindBy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Arquillian.class)
public class TestInitializingPageFragments {
    @FindBy(xpath="//div[@id='rootElement']")
    private AbstractPageFragmentStub abstractPageFragmentStub;
    @FindBy(xpath="//div[@id='rootElement']")
    private PageFragmentWithEmbeddedAnotherPageFragmentStub pageFragmentWithEmbeddedAnotherPageFragment;
    @FindBy(xpath="//input")
    private WebElement input;
    @FindBy(className="divs")
    private List<WebElement> divs;
    @Page
    private TestPage testPage;
    private final String EXPECTED_NESTED_ELEMENT_TEXT = "Some Value";
    @Drone
    private WebDriver selenium;

    public void loadPage() {
        URL page = this.getClass().getClassLoader().getResource("org/jboss/arquillian/graphene/ftest/pageFragmentsEnricher/sample.html");
        this.selenium.get(page.toExternalForm());
    }

    @Test
    public void testpageFragmentIsInitialized() {
        this.loadPage();
        Assert.assertNotNull((String)"AbstractPageFragment should be initialised at this point!", (Object)this.abstractPageFragmentStub);
    }

    @Test
    public void testPageFragmentHasSetRootCorrectly() {
        this.loadPage();
        Assert.assertEquals((String)"The root was not set correctly!", (Object)this.abstractPageFragmentStub.invokeMethodOnElementRefByXpath(), (Object)"Some Value");
    }

    @Test
    public void testPageObjectInitialisedCorrectly() {
        this.loadPage();
        Assert.assertEquals((String)"The page object was not set correctly!", (Object)this.testPage.getAbstractPageFragment().invokeMethodOnElementRefByXpath(), (Object)"Some Value");
    }

    @Test
    public void testOtherWebElementsInitialisedCorrectly() {
        this.loadPage();
        String EXPECTED_VALUE = "Gooseka";
        this.input.sendKeys(new CharSequence[]{EXPECTED_VALUE});
        Assert.assertEquals((String)"The value of the input is wrong, the element which represents it was not initialised correctly!", (Object)this.input.getAttribute("value"), (Object)EXPECTED_VALUE);
    }

    @Test
    public void testEmbeddedPageObjectInitializedCorrectly() {
        this.loadPage();
        Assert.assertEquals((String)"The embedded page was not initialized correctly!", (Object)"This is embedded element", (Object)this.testPage.getEmbeddedPage().invokeMethodOnEmbeddedElement());
    }

    @Test
    public void testInitializeListOfWebElementsInjectedToTests() {
        this.loadPage();
        this.checkInitializationOfWebElements(this.divs, "Outside PageFragment");
    }

    @Test
    public void testInitializeListOfWebElementsInjectedToPageFragments() {
        this.loadPage();
        this.checkInitializationOfWebElements(this.abstractPageFragmentStub.getSpansInPageFragment(), "Inside PageFragment");
    }

    @Test
    public void testInitializeListOfWebElementsInjectedToPageObject() {
        this.loadPage();
        this.checkInitializationOfWebElements(this.testPage.getParagraphs(), "Inside PageObject");
    }

    @Test
    public void testSupportForAdvancedActions() {
        this.loadPage();
        WebDriver driver = (WebDriver)GrapheneContext.getProxyForInterfaces((Class[])new Class[]{HasInputDevices.class});
        Actions builder = new Actions(driver);
        builder.click(this.input);
        builder.click(this.divs.get(0));
        builder.click(this.abstractPageFragmentStub.getLocatorRefByXPath());
        builder.click((WebElement)this.abstractPageFragmentStub.getSpansInPageFragment().get(0));
        builder.perform();
    }

    @Test
    public void testInitializationOfEmbeddedPageFragmentsInOtherPageFragments() {
        this.loadPage();
        WebElement element = this.pageFragmentWithEmbeddedAnotherPageFragment.getEmbeddedPageFragment().getLocatorRefByClassName();
        Assert.assertEquals((String)"The Page Fragment ebmedded in another Page Fragment was not initialized correctly!", (Object)element.getText(), (Object)"Value of element in embedded page fragment");
    }

    private void checkInitializationOfWebElements(List<WebElement> webElements, String expectedValueOfWebElements) {
        Assert.assertNotNull((String)"The list of WebElements was not initialized correctly!", webElements);
        for (int i = 1; i <= 3; ++i) {
            WebElement webElement = null;
            try {
                webElement = webElements.get(i - 1);
            }
            catch (IndexOutOfBoundsException ex) {
                Assert.fail((String)("The List<WebElement> was not initialized correclty! " + ex));
                return;
            }
            Assert.assertEquals((String)("The WebElement number " + i + " from list was not initialized correctly!"), (Object)(expectedValueOfWebElements + " " + String.valueOf(i)), (Object)webElement.getText());
        }
    }
}

