/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.net.URL;
import junit.framework.Assert;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.Select;

@RunWith(value=Arquillian.class)
public class TestWebElementWrapper {
    @Drone
    private WebDriver browser;
    @FindBy(css="#root span")
    private Wrapper1 wrapper1;
    @FindBy(css="#root span")
    private Wrapper2 wrapper2;
    @FindBy(tagName="select")
    private Select select;

    public void loadPage() {
        URL page = this.getClass().getClassLoader().getResource("org/jboss/arquillian/graphene/ftest/enricher/sample.html");
        this.browser.get(page.toString());
    }

    @Test
    public void testInnerStaticClassWrapper() {
        this.loadPage();
        Assert.assertNotNull((Object)this.wrapper1);
        Assert.assertEquals((String)"correct", (String)this.wrapper1.getText());
    }

    @Test
    public void testInnerClassWrapper() {
        this.loadPage();
        Assert.assertNotNull((Object)this.wrapper2);
        Assert.assertEquals((String)"correct", (String)this.wrapper2.getText());
    }

    @Test
    public void testSelect() {
        this.loadPage();
        Assert.assertEquals((int)3, (int)this.select.getOptions().size());
        this.select.selectByIndex(0);
        Assert.assertEquals((String)"one", (String)this.select.getFirstSelectedOption().getText());
    }

    public class Wrapper2 {
        private final WebElement element;

        public Wrapper2(WebElement element) {
            this.element = element;
        }

        public String getText() {
            return this.element.getText();
        }
    }

    public static class Wrapper1 {
        private final WebElement element;

        public Wrapper1(WebElement element) {
            this.element = element;
        }

        public String getText() {
            return this.element.getText();
        }
    }
}

