/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.condition;

import com.google.common.base.Function;
import java.net.URL;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.condition.AttributeConditionFactory;
import org.jboss.arquillian.graphene.condition.ElementConditionFactory;
import org.jboss.arquillian.graphene.condition.StringConditionFactory;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.DefaultElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.openqa.selenium.support.ui.Select;

@RunWith(value=Arquillian.class)
public class ConditionsTestCase {
    @Drone
    private WebDriver browser;
    private static final By BY_HEADER = By.id((String)"header");
    private static final By BY_OPTION1 = By.id((String)"option1");
    @FindBy(id="appear")
    private WebElement appearButton;
    @FindBy(id="header")
    private WebElement header;
    @FindBy(id="hide")
    private WebElement hideButton;
    @FindBy(id="idInput")
    private WebElement idInput;
    @FindBy(id="option1")
    private WebElement option1;
    @FindBy(id="select")
    private WebElement select;
    @FindBy(id="textInput")
    private WebElement textInput;
    @FindBy(id="submit")
    private WebElement updateButton;

    public void loadPage() {
        URL page = this.getClass().getClassLoader().getResource("org/jboss/arquillian/graphene/ftest/condition/sample.html");
        this.browser.get(page.toString());
        PageFactory.initElements((ElementLocatorFactory)new DefaultElementLocatorFactory((SearchContext)this.browser), (Object)this);
    }

    @Test
    public void testAttributeIsPresent() {
        this.loadPage();
        this.checkAttributeIsPresent(Graphene.attribute((WebElement)this.header, (String)"style"));
    }

    @Test
    public void testAttributeValueContains() {
        this.loadPage();
        this.checkAttributeValueContains(Graphene.attribute((WebElement)this.textInput, (String)"value"));
    }

    @Test
    public void testAttributeValueEquals() {
        this.loadPage();
        this.checkAttributeValueEquals(Graphene.attribute((WebElement)this.textInput, (String)"value"));
    }

    @Test
    public void testElementIsPresent() {
        this.loadPage();
        this.checkElementIsPresent(Graphene.element((WebElement)this.header));
    }

    @Test
    public void testElementIsPresentWithBy() {
        this.loadPage();
        this.checkElementIsPresent(Graphene.element((By)BY_HEADER));
    }

    @Test
    public void testElementIsSelected() {
        this.loadPage();
        this.checkElementIsSelected(Graphene.element((WebElement)this.option1));
    }

    @Test
    public void testElementIsSelectedWithBy() {
        this.loadPage();
        this.checkElementIsSelected(Graphene.element((By)BY_OPTION1));
    }

    @Test
    public void testElementIsVisible() {
        this.loadPage();
        this.checkElementIsVisible(Graphene.element((WebElement)this.header));
    }

    @Test
    public void testElementIsVisibleWithBy() {
        this.loadPage();
        this.checkElementIsVisible(Graphene.element((By)BY_HEADER));
    }

    @Test
    public void testElementTextContains() {
        this.loadPage();
        this.checkElementTextContains(Graphene.element((WebElement)this.header));
    }

    @Test
    public void testElementTextContainsWithBy() {
        this.loadPage();
        this.checkElementTextContains(Graphene.element((By)BY_HEADER));
    }

    @Test
    public void testElementTextEquals() {
        this.loadPage();
        this.checkElementTextEquals(Graphene.element((WebElement)this.header));
    }

    @Test
    public void testElementTextEqualsWithBy() {
        this.loadPage();
        this.checkElementTextEquals(Graphene.element((By)BY_HEADER));
    }

    protected void checkAttributeIsPresent(AttributeConditionFactory headerStyleAttributeFactory) {
        this.hideButton.click();
        Graphene.waitModel().until((Function)headerStyleAttributeFactory.isPresent());
        this.appearButton.click();
        Graphene.waitModel().until((Function)((AttributeConditionFactory)headerStyleAttributeFactory.not()).isPresent());
    }

    protected void checkAttributeValueContains(AttributeConditionFactory textInputValueAttributeFactory) {
        this.textInput.clear();
        Graphene.waitModel().until((Function)((AttributeConditionFactory)textInputValueAttributeFactory.not()).valueContains("Tested"));
        this.textInput.sendKeys(new CharSequence[]{"Tested Header"});
        Graphene.waitModel().until((Function)textInputValueAttributeFactory.valueContains("Tested"));
        this.textInput.clear();
        Graphene.waitModel().until((Function)((AttributeConditionFactory)textInputValueAttributeFactory.not()).contains("Tested"));
        Assert.assertTrue((boolean)((Boolean)((AttributeConditionFactory)textInputValueAttributeFactory.not()).contains("Tested").apply((Object)this.browser)));
        this.textInput.sendKeys(new CharSequence[]{"Tested Header"});
        Graphene.waitModel().until((Function)textInputValueAttributeFactory.contains("Tested"));
    }

    protected void checkAttributeValueEquals(AttributeConditionFactory textInputValueAttributeFactory) {
        this.textInput.clear();
        this.textInput.sendKeys(new CharSequence[]{"Tested"});
        Graphene.waitModel().until((Function)((AttributeConditionFactory)textInputValueAttributeFactory.not()).valueEquals("Tested Header"));
        this.textInput.sendKeys(new CharSequence[]{" Header"});
        Graphene.waitModel().until((Function)textInputValueAttributeFactory.valueEquals("Tested Header"));
        this.textInput.clear();
        this.textInput.sendKeys(new CharSequence[]{"Tested"});
        Graphene.waitModel().until((Function)((AttributeConditionFactory)textInputValueAttributeFactory.not()).equalTo("Tested Header"));
        Assert.assertTrue((boolean)((Boolean)((AttributeConditionFactory)textInputValueAttributeFactory.not()).equalTo("Tested Header").apply((Object)this.browser)));
        this.textInput.sendKeys(new CharSequence[]{" Header"});
        Graphene.waitModel().until((Function)textInputValueAttributeFactory.equalTo("Tested Header"));
    }

    protected void checkElementIsPresent(ElementConditionFactory headerElementFactory) {
        this.idInput.clear();
        this.idInput.sendKeys(new CharSequence[]{"header2"});
        this.updateButton.click();
        Graphene.waitModel((WebDriver)this.browser).until((Function)((ElementConditionFactory)headerElementFactory.not()).isPresent());
        this.idInput.clear();
        this.idInput.sendKeys(new CharSequence[]{"header"});
        this.updateButton.click();
        Graphene.waitModel((WebDriver)this.browser).until((Function)headerElementFactory.isPresent());
    }

    protected void checkElementIsSelected(ElementConditionFactory option1ElementFactory) {
        new Select(this.select).selectByIndex(0);
        Graphene.waitModel().until((Function)option1ElementFactory.isSelected());
        new Select(this.select).selectByIndex(1);
        Graphene.waitModel().until((Function)((ElementConditionFactory)option1ElementFactory.not()).isSelected());
    }

    protected void checkElementTextContains(ElementConditionFactory headerElementFactory) {
        this.textInput.clear();
        this.textInput.sendKeys(new CharSequence[]{"florence and the machine"});
        this.updateButton.click();
        Graphene.waitModel().until((Function)headerElementFactory.textContains("machine"));
        this.textInput.clear();
        this.textInput.sendKeys(new CharSequence[]{"Tested Header"});
        this.updateButton.click();
        Graphene.waitModel().until((Function)((ElementConditionFactory)headerElementFactory.not()).textContains("machine"));
        this.textInput.clear();
        this.textInput.sendKeys(new CharSequence[]{"florence and the machine"});
        this.updateButton.click();
        Graphene.waitModel().until((Function)headerElementFactory.text().contains("machine"));
        Assert.assertTrue((boolean)((Boolean)headerElementFactory.text().contains("machine").apply((Object)this.browser)));
        this.textInput.clear();
        this.textInput.sendKeys(new CharSequence[]{"Tested Header"});
        this.updateButton.click();
        Graphene.waitModel().until((Function)((StringConditionFactory)headerElementFactory.text().not()).contains("machine"));
    }

    protected void checkElementTextEquals(ElementConditionFactory headerElementFactory) {
        this.textInput.clear();
        this.textInput.sendKeys(new CharSequence[]{"florence and the machine"});
        this.updateButton.click();
        Graphene.waitModel().until((Function)headerElementFactory.textEquals("florence and the machine"));
        this.textInput.sendKeys(new CharSequence[]{"Tested Header"});
        this.updateButton.click();
        Graphene.waitModel().until((Function)((ElementConditionFactory)headerElementFactory.not()).textEquals("florence and the machine"));
        this.textInput.clear();
        this.textInput.sendKeys(new CharSequence[]{"florence and the machine"});
        this.updateButton.click();
        Graphene.waitModel().until((Function)headerElementFactory.text().equalTo("florence and the machine"));
        Assert.assertTrue((boolean)((Boolean)headerElementFactory.text().equalTo("florence and the machine").apply((Object)this.browser)));
        this.textInput.sendKeys(new CharSequence[]{"Tested Header"});
        this.updateButton.click();
        Graphene.waitModel().until((Function)((StringConditionFactory)headerElementFactory.text().not()).equalTo("florence and the machine"));
    }

    protected void checkElementIsVisible(ElementConditionFactory headerElementFactory) {
        this.hideButton.click();
        Graphene.waitModel().until((Function)((ElementConditionFactory)headerElementFactory.not()).isVisible());
        this.appearButton.click();
        Graphene.waitModel().until((Function)headerElementFactory.isVisible());
    }
}

