/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.guard;

import java.net.URL;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.guard.RequestGuardException;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

@RunWith(value=Arquillian.class)
public class GuardsTestCase {
    @FindBy(id="http")
    private WebElement http;
    @FindBy(id="none")
    private WebElement none;
    @FindBy(id="xhr")
    private WebElement xhr;
    @FindBy(id="xhr-delayed-trigerring")
    private WebElement xhrDelayedTrigerring;
    @FindBy(id="xhr-delayed-processing")
    private WebElement xhrDelayedProcessing;
    @FindBy(id="xhr-delayed-trigerring-and-processing")
    private WebElement xhrDelayedTrigerringAndProcessing;
    @FindBy(id="xhr-delayed-processing-with-code-arg")
    private WebElement xhrDelayedProcessingWithCodeArgument;
    @FindBy(id="status")
    private WebElement status;
    @Drone
    private WebDriver browser;

    @Before
    public void loadPage() {
        URL url = this.getClass().getClassLoader().getResource("org/jboss/arquillian/graphene/ftest/guard/sample1.html");
        this.browser.get(url.toString());
    }

    @Test
    public void testGuardType() {
        Assert.assertTrue((boolean)(Graphene.guardAjax((Object)this.browser) instanceof WebDriver));
        Assert.assertTrue((boolean)(Graphene.guardHttp((Object)this.browser) instanceof WebDriver));
        Assert.assertTrue((boolean)(Graphene.guardNoRequest((Object)this.browser) instanceof WebDriver));
    }

    @Test
    public void testGuardHttp() {
        ((WebElement)Graphene.guardHttp((Object)this.http)).click();
    }

    @Test
    public void testGuardNoRequest() {
        ((WebElement)Graphene.guardNoRequest((Object)this.none)).click();
    }

    @Test
    public void testGuardAjax() {
        ((WebElement)Graphene.guardAjax((Object)this.xhr)).click();
        Assert.assertTrue((boolean)this.status.getText().contains("DONE"));
    }

    @Test
    public void testGuardDelayedAjax() {
        ((WebElement)Graphene.guardAjax((Object)this.xhrDelayedTrigerring)).click();
        Assert.assertTrue((boolean)this.status.getText().contains("DONE"));
    }

    @Test
    public void testGuardDelayedAjaxProcessing() {
        ((WebElement)Graphene.guardAjax((Object)this.xhrDelayedProcessing)).click();
        Assert.assertTrue((boolean)this.status.getText().contains("DONE"));
    }

    @Test
    public void testGuardDelayedTrigerringAndProcessing() {
        ((WebElement)Graphene.guardAjax((Object)this.xhrDelayedTrigerringAndProcessing)).click();
        Assert.assertTrue((boolean)this.status.getText().contains("DONE"));
    }

    @Test
    public void testGuardDelayedAjaxProcessingWithCodeArgument() {
        ((WebElement)Graphene.guardAjax((Object)this.xhrDelayedProcessingWithCodeArgument)).click();
        Assert.assertTrue((boolean)this.status.getText().contains("DONE"));
    }

    @Test
    public void testGuardAjaxWithRelocation() throws Exception {
        XhrAndRelocationActivity relocation = new XhrAndRelocationActivity();
        ((Activity)Graphene.waitForHttp((Object)relocation)).perform();
    }

    @Test(expected=RequestGuardException.class)
    public void testGuardHttpFailure() {
        ((WebElement)Graphene.guardHttp((Object)this.xhr)).click();
    }

    @Test(expected=RequestGuardException.class)
    public void testGuardNoRequestFailure() {
        ((WebElement)Graphene.guardNoRequest((Object)this.http)).click();
    }

    @Test(expected=RequestGuardException.class)
    public void testGuardAjaxFailure() {
        ((WebElement)Graphene.guardAjax((Object)this.http)).click();
    }

    @Test(expected=RequestGuardException.class)
    public void testDelayedGuardNoRequest() {
        ((WebElement)Graphene.guardNoRequest((Object)this.xhrDelayedTrigerring)).click();
    }

    public static class XhrAndRelocationActivity
    implements Activity {
        public void perform() throws Exception {
            WebDriver browser = GrapheneContext.getProxy();
            browser.findElement(By.id((String)"xhr")).click();
            String url = browser.getCurrentUrl().replace("sample1", "sample2");
            Thread.sleep(200L);
            browser.get(url);
        }
    }

    public static interface Activity {
        public void perform() throws Exception;
    }
}

