/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.webdriver;

import java.net.URL;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.enricher.findby.JQuery;
import org.jboss.arquillian.graphene.javascript.Dependency;
import org.jboss.arquillian.graphene.javascript.JavaScript;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Action;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.FindBy;

@RunWith(value=Arquillian.class)
public class FindElementTestCase {
    @Drone
    private WebDriver browser;
    @FindBy(className="make-stale")
    private WebElement makeStale;
    @JavaScript
    JQueryInstallator installator;

    @Before
    public void loadPage() {
        URL page = this.getClass().getClassLoader().getResource("org/jboss/arquillian/graphene/ftest/webdriver/staleelements.html");
        this.browser.get(page.toString());
    }

    @Test
    public void testFindStaleElementOnWebDriver() {
        WebElement stale = this.browser.findElement(By.className((String)"stale"));
        Assert.assertTrue((boolean)stale.isDisplayed());
        this.makeStale.click();
        Assert.assertTrue((boolean)stale.isDisplayed());
    }

    @Test
    public void testFindStaleElementsOnWebDriver() {
        WebElement stale = (WebElement)this.browser.findElements(By.className((String)"stale")).get(0);
        this.makeStale.click();
        Assert.assertTrue((boolean)stale.isDisplayed());
    }

    @Test
    public void testFindStaleElementOnWebElement() {
        WebElement stale = this.browser.findElement(By.tagName((String)"body")).findElement(By.className((String)"stale"));
        this.makeStale.click();
        Assert.assertTrue((boolean)stale.isDisplayed());
    }

    @Test
    public void testFindStaleElementsOnWebElement() {
        WebElement stale = (WebElement)this.browser.findElement(By.tagName((String)"body")).findElements(By.className((String)"stale")).get(0);
        this.makeStale.click();
        Assert.assertTrue((boolean)stale.isDisplayed());
    }

    @Test
    public void testFindElementOnStaleWebElement() {
        WebElement inStale = this.browser.findElement(By.className((String)"stale")).findElement(By.className((String)"in-stale"));
        this.makeStale.click();
        Assert.assertTrue((boolean)inStale.isDisplayed());
    }

    @Test
    public void testFindElementsOnStaleWebElement() {
        WebElement inStale = (WebElement)this.browser.findElement(By.className((String)"stale")).findElements(By.className((String)"in-stale")).get(0);
        this.makeStale.click();
        Assert.assertTrue((boolean)inStale.isDisplayed());
    }

    @Test
    public void testStelenessAndJavascriptOnWebDriver() {
        WebElement stale = this.browser.findElement(By.className((String)"stale"));
        this.makeStale.click();
        JavascriptExecutor executor = (JavascriptExecutor)this.browser;
        this.installator.install();
        executor.executeScript("Graphene.jQuery(arguments[0]).trigger('blur')", new Object[]{stale});
    }

    @Test
    public void testStelenessAndJavascriptOnWebElement() {
        WebElement inStale = this.browser.findElement(By.className((String)"stale")).findElement(By.className((String)"in-stale"));
        this.makeStale.click();
        JavascriptExecutor executor = (JavascriptExecutor)this.browser;
        this.installator.install();
        executor.executeScript("Graphene.jQuery(arguments[0]).trigger('blur')", new Object[]{inStale});
    }

    @Test
    public void testStalenessAndActionsOnWebDriver1() {
        WebElement stale = this.browser.findElement(By.className((String)"stale"));
        Action action = new Actions(this.browser).clickAndHold(stale).release(stale).build();
        this.makeStale.click();
        action.perform();
    }

    @Test
    public void testStalenessAndActionsOnWebDriver2() {
        WebElement stale = this.browser.findElement(By.className((String)"stale"));
        Action action = new Actions(this.browser).moveToElement(stale).build();
        this.makeStale.click();
        action.perform();
    }

    @Test
    public void testStalenessAndActionsOnWebElement1() {
        WebElement inStale = this.browser.findElement(By.className((String)"stale")).findElement(By.className((String)"in-stale"));
        Action action = new Actions(this.browser).clickAndHold(inStale).release(inStale).build();
        this.makeStale.click();
        action.perform();
    }

    @Test
    public void testStalenessAndActionsOnWebElement2() {
        WebElement inStale = this.browser.findElement(By.className((String)"stale")).findElement(By.className((String)"in-stale"));
        Action action = new Actions(this.browser).moveToElement(inStale).build();
        this.makeStale.click();
        action.perform();
    }

    @JavaScript(value="Graphene.jqueryInstallator")
    @Dependency(sources={"org/jboss/arquillian/graphene/ftest/webdriver/jqueryInstallator.js"}, interfaces={JQuery.class})
    public static interface JQueryInstallator {
        public Boolean install();
    }
}

