/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.enricher;

import java.net.URL;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.ftest.Resource;
import org.jboss.arquillian.graphene.ftest.Resources;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.Select;

@RunWith(value=Arquillian.class)
@RunAsClient
public class TestInitializeEmptyFindBy {
    @Drone
    private WebDriver browser;
    @FindBy
    private WebElement divWebElement;
    @FindBy
    private SpanFragment spanFragment;
    @FindBy
    private Select selectElement;
    @FindBy
    private WebElement nameOfInputElement;
    @Page
    private PageObject pageObjectWithSeleniumFindBys;
    @ArquillianResource
    private URL contextRoot;

    @Deployment
    public static WebArchive createTestArchive() {
        return Resources.inCurrentPackage().all().buildWar("test.war");
    }

    @Before
    public void loadPage() {
        Resource.inCurrentPackage().find("empty-findby.html").loadPage(this.browser, this.contextRoot);
    }

    @Test
    public void testWebElementById() {
        this.checkWebElementById(this.divWebElement);
    }

    @Test
    public void testWebElementByName() {
        this.checkWebElementByName(this.nameOfInputElement);
    }

    @Test
    public void testPageFragmentById() {
        this.checkPageFragmentById(this.spanFragment);
    }

    @Test
    public void testSelectById() {
        this.checkSelectById(this.selectElement);
    }

    @Test
    public void testSeleniumFindBy() {
        this.checkPageFragmentById(this.pageObjectWithSeleniumFindBys.getSpanFragment());
        this.checkSelectById(this.pageObjectWithSeleniumFindBys.getSelectElement());
        this.checkWebElementById(this.pageObjectWithSeleniumFindBys.getDivWebElement());
        this.checkWebElementByName(this.pageObjectWithSeleniumFindBys.getNameOfInputElement());
    }

    private void checkWebElementById(WebElement element) {
        Assert.assertNotNull((Object)element);
        Assert.assertEquals((Object)"WebElement content", (Object)element.getText());
    }

    private void checkWebElementByName(WebElement element) {
        Assert.assertNotNull((Object)element);
        String expected = "Test";
        element.sendKeys(new CharSequence[]{expected});
        Assert.assertEquals((Object)expected, (Object)element.getAttribute("value"));
    }

    private void checkPageFragmentById(SpanFragment fragment) {
        Assert.assertNotNull((Object)fragment);
        Assert.assertEquals((Object)"1", (Object)fragment.getSpan().get(0).getText());
    }

    private void checkSelectById(Select select) {
        Assert.assertNotNull((Object)select);
        select.selectByIndex(1);
        Assert.assertEquals((Object)"two", (Object)select.getFirstSelectedOption().getText());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SpanFragment {
        @FindBy(tagName="span")
        private List<WebElement> span;

        public List<WebElement> getSpan() {
            return this.span;
        }
    }

    public class PageObject {
        @FindBy
        private WebElement divWebElement;
        @FindBy
        private SpanFragment spanFragment;
        @FindBy
        private Select selectElement;
        @FindBy
        private WebElement nameOfInputElement;

        public WebElement getDivWebElement() {
            return this.divWebElement;
        }

        public WebElement getNameOfInputElement() {
            return this.nameOfInputElement;
        }

        public Select getSelectElement() {
            return this.selectElement;
        }

        public SpanFragment getSpanFragment() {
            return this.spanFragment;
        }
    }
}

