/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.guard;

import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.ftest.Resource;
import org.jboss.arquillian.graphene.ftest.Resources;
import org.jboss.arquillian.graphene.javascript.JavaScript;
import org.jboss.arquillian.graphene.request.RequestGuard;
import org.jboss.arquillian.graphene.request.RequestGuardException;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

@RunWith(value=Arquillian.class)
@RunAsClient
public class GuardsTestCase {
    @ArquillianResource
    private URL contextRoot;
    @FindBy(id="http")
    private WebElement http;
    @FindBy(id="none")
    private WebElement none;
    @FindBy(id="xhr")
    private WebElement xhr;
    @FindBy(id="xhr-delayed-trigerring")
    private WebElement xhrDelayedTrigerring;
    @FindBy(id="xhr-delayed-processing")
    private WebElement xhrDelayedProcessing;
    @FindBy(id="xhr-delayed-trigerring-and-processing")
    private WebElement xhrDelayedTrigerringAndProcessing;
    @FindBy(id="xhr-delayed-processing-with-code-arg")
    private WebElement xhrDelayedProcessingWithCodeArgument;
    @FindBy(id="status")
    private WebElement status;
    @JavaScript
    private RequestGuard guard;
    @Drone
    private WebDriver browser;

    @Deployment
    public static WebArchive createTestArchive() {
        return Resources.inCurrentPackage().all().buildWar("test.war");
    }

    @Before
    public void loadPage() {
        Resource.inCurrentPackage().find("sample1.html").loadPage(this.browser, this.contextRoot);
    }

    @Test
    public void testGuardType() {
        Assert.assertTrue((boolean)(Graphene.guardAjax((Object)this.browser) instanceof WebDriver));
        Assert.assertTrue((boolean)(Graphene.guardHttp((Object)this.browser) instanceof WebDriver));
        Assert.assertTrue((boolean)(Graphene.guardNoRequest((Object)this.browser) instanceof WebDriver));
    }

    @Test
    public void testGuardHttp() {
        ((WebElement)Graphene.guardHttp((Object)this.http)).click();
    }

    @Test
    public void testGuardNoRequest() {
        ((WebElement)Graphene.guardNoRequest((Object)this.none)).click();
    }

    @Test
    public void testGuardAjax() {
        ((WebElement)Graphene.guardAjax((Object)this.xhr)).click();
        Assert.assertTrue((boolean)this.status.getText().contains("DONE"));
    }

    @Test
    public void testGuardDelayedAjax() {
        ((WebElement)Graphene.guardAjax((Object)this.xhrDelayedTrigerring)).click();
        Assert.assertTrue((boolean)this.status.getText().contains("DONE"));
    }

    @Test
    public void testGuardDelayedAjaxProcessing() {
        this.guard.setMaximumCallbackTimeout(1500);
        ((WebElement)Graphene.guardAjax((Object)this.xhrDelayedProcessing)).click();
        Assert.assertTrue((boolean)this.status.getText().contains("DONE"));
    }

    @Test
    public void testGuardDelayedTrigerringAndProcessing() {
        this.guard.setMaximumCallbackTimeout(1500);
        ((WebElement)Graphene.guardAjax((Object)this.xhrDelayedTrigerringAndProcessing)).click();
        Assert.assertTrue((boolean)this.status.getText().contains("DONE"));
    }

    @Test
    public void testGuardDelayedAjaxProcessingWithCodeArgument() {
        this.guard.setMaximumCallbackTimeout(1500);
        ((WebElement)Graphene.guardAjax((Object)this.xhrDelayedProcessingWithCodeArgument)).click();
        Assert.assertTrue((boolean)this.status.getText().contains("DONE"));
    }

    @Test
    public void testGuardAjaxWithRelocation() throws Exception {
        XhrAndRelocationActivity relocation = new XhrAndRelocationActivity();
        ((Activity)Graphene.waitForHttp((Object)relocation)).perform();
    }

    @Test(expected=RequestGuardException.class)
    public void testGuardHttpFailure() {
        ((WebElement)Graphene.guardHttp((Object)this.xhr)).click();
    }

    @Test(expected=RequestGuardException.class)
    public void testGuardNoRequestFailure() {
        ((WebElement)Graphene.guardNoRequest((Object)this.http)).click();
    }

    @Test(expected=RequestGuardException.class)
    public void testGuardAjaxFailure() {
        ((WebElement)Graphene.guardAjax((Object)this.http)).click();
    }

    @Test(expected=RequestGuardException.class)
    public void testDelayedGuardNoRequest() {
        ((WebElement)Graphene.guardNoRequest((Object)this.xhrDelayedTrigerring)).click();
    }

    public class XhrAndRelocationActivity
    implements Activity {
        public void perform() throws Exception {
            GuardsTestCase.this.browser.findElement(By.id((String)"xhr")).click();
            String url = GuardsTestCase.this.browser.getCurrentUrl().replace("sample1", "sample2");
            Thread.sleep(200L);
            GuardsTestCase.this.browser.get(url);
        }
    }

    public static interface Activity {
        public void perform() throws Exception;
    }
}

