/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.enricher;

import java.net.URL;
import junit.framework.Assert;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.ftest.Resource;
import org.jboss.arquillian.graphene.ftest.Resources;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

@RunWith(value=Arquillian.class)
@RunAsClient
public class TestDroneIntegrationWhenDroneIsUsedInTest {
    @Drone
    private WebDriver browser;
    @Page
    private DronePage page;
    @FindBy(id="root")
    private DronePageFragment pageFragment;
    @ArquillianResource
    private URL contextRoot;

    @Deployment
    public static WebArchive createTestArchive() {
        return Resources.inCurrentPackage().all().buildWar("test.war");
    }

    public void loadPage(WebDriver browser) {
        Resource.inCurrentPackage().find("sample.html").loadPage(browser, this.contextRoot);
    }

    @Test
    public void testDronePageNotNull() {
        Assert.assertNotNull((Object)this.page.getBrowser());
    }

    @Test
    public void testDronePageFragmentNotNull() {
        Assert.assertNotNull((Object)this.pageFragment.getBrowser());
    }

    @Test
    public void testDronePageTitle() {
        this.loadPage(this.page.getBrowser());
        Assert.assertEquals((String)"Sample Page", (String)this.page.getBrowser().getTitle());
    }

    @Test
    public void testDronePageFragmentTitle() {
        this.loadPage(this.pageFragment.getBrowser());
        Assert.assertEquals((String)"Sample Page", (String)this.pageFragment.getBrowser().getTitle());
    }

    public static class DronePageFragment {
        @Drone
        private WebDriver browser;
        @FindBy(tagName="span")
        private WebElement span;

        public WebDriver getBrowser() {
            return this.browser;
        }

        public WebElement getSpan() {
            return this.span;
        }
    }

    public static class DronePage {
        @Drone
        private WebDriver browser;

        public WebDriver getBrowser() {
            return this.browser;
        }
    }
}

