/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.enricher;

import java.net.URL;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.ftest.Resource;
import org.jboss.arquillian.graphene.ftest.Resources;
import org.jboss.arquillian.graphene.ftest.enricher.page.TestPage;
import org.jboss.arquillian.graphene.ftest.enricher.page.fragment.AbstractPageFragmentStub;
import org.jboss.arquillian.graphene.ftest.enricher.page.fragment.PageFragmentWithEmbeddedAnotherPageFragmentStub;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.FindBy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Arquillian.class)
@RunAsClient
public class TestInitializingPageFragments {
    @FindBy(xpath="//div[@id='rootElement']")
    private AbstractPageFragmentStub abstractPageFragmentStub;
    @FindBy(xpath="//div[@id='rootElement']")
    private PageFragmentWithEmbeddedAnotherPageFragmentStub pageFragmentWithEmbeddedAnotherPageFragment;
    @FindBy(xpath="//input")
    private WebElement input;
    @FindBy(className="divs")
    private List<WebElement> divs;
    @Page
    private TestPage testPage;
    private final String EXPECTED_NESTED_ELEMENT_TEXT = "Some Value";
    @Drone
    private WebDriver selenium;
    @ArquillianResource
    private URL contextRoot;

    @Deployment
    public static WebArchive createTestArchive() {
        return Resources.inPackage("org.jboss.arquillian.graphene.ftest.pageFragmentsEnricher").all().buildWar("test.war");
    }

    @Before
    public void loadPage() {
        Resource.inPackage("org.jboss.arquillian.graphene.ftest.pageFragmentsEnricher").find("sample.html").loadPage(this.selenium, this.contextRoot);
    }

    @Test
    public void testpageFragmentIsInitialized() {
        Assert.assertNotNull((String)"AbstractPageFragment should be initialised at this point!", (Object)this.abstractPageFragmentStub);
    }

    @Test
    public void testPageFragmentHasSetRootCorrectly() {
        Assert.assertEquals((String)"The root was not set correctly!", (Object)this.abstractPageFragmentStub.invokeMethodOnElementRefByXpath(), (Object)"Some Value");
    }

    @Test
    public void testPageObjectInitialisedCorrectly() {
        Assert.assertEquals((String)"The page object was not set correctly!", (Object)this.testPage.getAbstractPageFragment().invokeMethodOnElementRefByXpath(), (Object)"Some Value");
    }

    @Test
    public void testOtherWebElementsInitialisedCorrectly() {
        String EXPECTED_VALUE = "Gooseka";
        this.input.sendKeys(new CharSequence[]{EXPECTED_VALUE});
        Assert.assertEquals((String)"The value of the input is wrong, the element which represents it was not initialised correctly!", (Object)this.input.getAttribute("value"), (Object)EXPECTED_VALUE);
    }

    @Test
    public void testEmbeddedPageObjectInitializedCorrectly() {
        Assert.assertEquals((String)"The embedded page was not initialized correctly!", (Object)"This is embedded element", (Object)this.testPage.getEmbeddedPage().invokeMethodOnEmbeddedElement());
    }

    @Test
    public void testInitializeListOfWebElementsInjectedToTests() {
        this.checkInitializationOfWebElements(this.divs, "Outside PageFragment");
    }

    @Test
    public void testInitializeListOfWebElementsInjectedToPageFragments() {
        this.checkInitializationOfWebElements(this.abstractPageFragmentStub.getSpansInPageFragment(), "Inside PageFragment");
    }

    @Test
    public void testInitializeListOfWebElementsInjectedToPageObject() {
        this.checkInitializationOfWebElements(this.testPage.getParagraphs(), "Inside PageObject");
    }

    @Test
    public void testSupportForAdvancedActions() {
        Actions builder = new Actions(this.selenium);
        builder.click(this.input);
        builder.click(this.divs.get(0));
        builder.click(this.abstractPageFragmentStub.getLocatorRefByXPath());
        builder.click(this.abstractPageFragmentStub.getSpansInPageFragment().get(0));
        builder.perform();
    }

    @Test
    public void testInitializationOfEmbeddedPageFragmentsInOtherPageFragments() {
        WebElement element = this.pageFragmentWithEmbeddedAnotherPageFragment.getEmbeddedPageFragment().getLocatorRefByClassName();
        Assert.assertEquals((String)"The Page Fragment ebmedded in another Page Fragment was not initialized correctly!", (Object)element.getText(), (Object)"Value of element in embedded page fragment");
    }

    private void checkInitializationOfWebElements(List<WebElement> webElements, String expectedValueOfWebElements) {
        Assert.assertNotNull((String)"The list of WebElements was not initialized correctly!", webElements);
        for (int i = 1; i <= 3; ++i) {
            WebElement webElement = null;
            try {
                webElement = webElements.get(i - 1);
            }
            catch (IndexOutOfBoundsException ex) {
                Assert.fail((String)("The List<WebElement> was not initialized correclty! " + ex));
                return;
            }
            Assert.assertEquals((String)("The WebElement number " + i + " from list was not initialized correctly!"), (Object)(expectedValueOfWebElements + " " + String.valueOf(i)), (Object)webElement.getText());
        }
    }
}

