/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jboss.arquillian.graphene.ftest.Resource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resources {
    private final Collection<Resource> resources;
    private final String pkg;

    private Resources(String pkg, Collection<Resource> resources) {
        this.resources = resources;
        this.pkg = pkg;
    }

    public static Resources inCurrentPackage() {
        try {
            String pkg = Class.forName(Thread.currentThread().getStackTrace()[2].getClassName()).getPackage().getName();
            return new Resources(pkg, Collections.EMPTY_LIST);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Can't load the current package.", e);
        }
    }

    public static Resources inPackage(String pkg) {
        return new Resources(pkg, Collections.EMPTY_LIST);
    }

    public Resources find(String resource) {
        ArrayList<Resource> newResources = new ArrayList<Resource>(this.resources);
        newResources.add(Resource.inPackage(this.pkg).find(resource));
        return new Resources(this.pkg, newResources);
    }

    public Resources all() {
        ArrayList<Resource> newResources = new ArrayList<Resource>(this.resources);
        newResources.addAll(Resource.inPackage(this.pkg).all());
        return new Resources(this.pkg, newResources);
    }

    public WebArchive buildWar(String name) {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)name);
        for (Resource resource : this.resources) {
            archive = (WebArchive)archive.addAsWebResource(resource.location, resource.location);
        }
        return archive;
    }
}

