/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.enricher;

import java.net.URL;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.jboss.arquillian.graphene.ftest.Resource;
import org.jboss.arquillian.graphene.ftest.Resources;
import org.jboss.arquillian.graphene.ftest.enricher.page.PageWithIFrames;
import org.jboss.arquillian.graphene.ftest.enricher.page.PageWithIFrames2;
import org.jboss.arquillian.graphene.ftest.enricher.page.fragment.PageFragmentWithSpan;
import org.jboss.arquillian.graphene.page.InFrame;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import qualifier.Browser1;
import qualifier.Browser2;

@RunWith(value=Arquillian.class)
@RunAsClient
public class TestInFrameFunctionality {
    @Drone
    private WebDriver browser;
    @Page
    private PageWithIFrames page;
    @Page
    @InFrame(index=0)
    private PageWithIFrames2 page2;
    @InFrame(nameOrId="second")
    @FindBy(id="root")
    private PageFragmentWithSpan myFragment;
    @InFrame(index=0)
    @FindBy(tagName="span")
    private WebElement span;
    @InFrame(index=0)
    @FindByJQuery(value="span")
    private WebElement spanByJQuery;
    @FindBy(className="divElement")
    private WebElement elementInDefaultFrame;
    @Browser1
    @Drone
    protected WebDriver browser1;
    @Browser2
    @Drone
    protected WebDriver browser2;
    @Browser2
    @Page
    private PageWithIFrames pageMultipleBrowsers;
    @Browser1
    @Page
    @InFrame(index=0)
    private PageWithIFrames2 page2MultipleBrowsers;
    @Browser2
    @InFrame(nameOrId="second")
    @FindBy(id="root")
    private PageFragmentWithSpan myFragmentMultipleBrowsers;
    @Browser1
    @InFrame(index=0)
    @FindBy(tagName="span")
    private WebElement spanMultipleBrowsers;
    @Browser2
    @FindBy(className="divElement")
    private WebElement elementInDefaultFrameMultipleBrowsers;
    @ArquillianResource
    private URL contextRoot;
    private static final String EXPECTED_WEB_ELEMENT_IN_FRAME_TEXT = "not correct";
    private static final String EXPECTED_WEB_ELEMENT_OUTSIDE_IFRAME_TEXT = "Outsider div element";
    private static final String EXPECTED_SELECT_FIRST_OPTION_TEXT = "option one";

    @Deployment
    public static WebArchive createTestArchive() {
        return Resources.inCurrentPackage().all().buildWar("test.war");
    }

    @Before
    public void loadPage() {
        this.loadTheRightPage(this.browser);
        this.loadTheRightPage(this.browser1);
        this.loadTheRightPage(this.browser2);
    }

    private void loadTheRightPage(WebDriver browser) {
        Resource.inCurrentPackage().find("inframe.html").loadPage(browser, this.contextRoot);
    }

    @Test
    public void testWebElementInFrameDefinedByIndex() {
        this.checkWebElementInFrame(this.page.getSpan());
    }

    @Test
    public void testInFrameOverPageObject1() {
        this.checkWebElementInFrame(this.page2.getSpan());
    }

    @Test
    public void testInFrameOverPageObject2() {
        this.checkWebElementInFrame(this.page2.getTextFromSpan());
    }

    @Test
    public void testInFrameOverPageObject4() {
        this.checkWebElementInFrame(this.page2.getSpan());
    }

    @Test
    public void testInFrameOverPageObjectMultipleBrowsers() {
        Resources.inCurrentPackage();
        this.checkWebElementInFrame(this.page2MultipleBrowsers.getSpan());
    }

    @Test
    public void testWebElementInFrameDeclaredInTest() {
        this.checkWebElementInFrame(this.span);
    }

    @Test
    public void testWebElementInFrameFoundByJQueryDeclaredInTest() {
        this.checkWebElementInFrame(this.spanByJQuery);
    }

    @Test
    public void testWebElementInFrameDeclaredInTestMultipleBrowsers() {
        this.checkWebElementInFrame(this.spanMultipleBrowsers);
    }

    @Test
    public void testPageFragmentInFrameDefinedById() {
        this.checkPageFragmentInFrame(this.page.getMyFragment());
    }

    @Test
    public void testPageFragmentInFrameDefinedByIdMultipleBrowsers() {
        this.checkPageFragmentInFrame(this.pageMultipleBrowsers.getMyFragment());
    }

    @Test
    public void testPageFragmentInFrameDeclaredInTest() {
        this.checkPageFragmentInFrame(this.myFragment);
    }

    @Test
    public void testPageFragmentInFrameDeclaredInTest2() {
        String text = this.myFragment.getSpanText();
        Assert.assertEquals((Object)"1", (Object)text);
    }

    @Test
    public void testPageFragmentInFrameDeclaredInTestMultipleBrowsers() {
        this.checkPageFragmentInFrame(this.myFragmentMultipleBrowsers);
    }

    @Test
    public void testSelectInFrameDefinedByName() {
        List options = this.page.getSelect().getOptions();
        Assert.assertEquals((long)3L, (long)options.size());
        Assert.assertEquals((Object)EXPECTED_SELECT_FIRST_OPTION_TEXT, (Object)((WebElement)options.get(0)).getText());
    }

    @Test
    public void testSelectInFrameDefinedByNameMultipleBrowsers() {
        List options = this.pageMultipleBrowsers.getSelect().getOptions();
        Assert.assertEquals((long)3L, (long)options.size());
        Assert.assertEquals((Object)EXPECTED_SELECT_FIRST_OPTION_TEXT, (Object)((WebElement)options.get(0)).getText());
    }

    @Test
    public void testInFrameOverPageObject3() {
        List options = this.page2.getSelect().getOptions();
        Assert.assertEquals((long)3L, (long)options.size());
        Assert.assertEquals((Object)EXPECTED_SELECT_FIRST_OPTION_TEXT, (Object)((WebElement)options.get(0)).getText());
    }

    @Test
    public void testInFrameOverPageObject2MultipleBrowsers() {
        List options = this.page2MultipleBrowsers.getSelect().getOptions();
        Assert.assertEquals((long)3L, (long)options.size());
        Assert.assertEquals((Object)EXPECTED_SELECT_FIRST_OPTION_TEXT, (Object)((WebElement)options.get(0)).getText());
    }

    @Test
    public void testElementInDefaultFrame() {
        this.checkWebElementInDefaultFrame(this.page.getElementInDefaultFrame());
    }

    @Test
    public void testElementInDefaultFrameMultipleBrowsers() {
        this.checkWebElementInDefaultFrame(this.pageMultipleBrowsers.getElementInDefaultFrame());
    }

    @Test
    public void testElementInDefaultFrameDeclaredInTest() {
        this.checkWebElementInDefaultFrame(this.elementInDefaultFrame);
    }

    @Test
    public void testElementInDefaultFrameDeclaredInTestMultipleBrowsers() {
        this.checkWebElementInDefaultFrame(this.elementInDefaultFrameMultipleBrowsers);
    }

    @Test
    public void testPageFragmenInFrameMoreComplexInteractions() {
        List<WebElement> spans = this.page.getMyFragment().getSpans();
        WebElement span = this.page.getMyFragment().getSpan();
        this.checkPageFragmentInFrame(this.page.getMyFragment());
        this.checkWebElementInDefaultFrame(this.page.getElementInDefaultFrame());
        String spanText = span.getText();
        Assert.assertEquals((Object)"1", (Object)spanText);
        int sizeOfList = spans.size();
        Assert.assertEquals((long)4L, (long)sizeOfList);
        for (int i = 0; i < sizeOfList; ++i) {
            String text = this.page.getMyFragment().getSpans().get(i).getText();
            Assert.assertTrue((!text.contains("fail") ? 1 : 0) != 0);
            Assert.assertEquals((Object)(i + 1), (Object)Integer.valueOf(text.trim()));
        }
    }

    @Test
    public void testMoreComplexInteractingWithInFrameElements() {
        this.checkWebElementInFrame(this.page.getSpan());
        this.checkWebElementInFrame(this.page.getSpan());
        WebElement element = this.browser.findElement(By.className((String)"divElement"));
        this.checkWebElementInDefaultFrame(element);
        this.checkPageFragmentInFrame(this.page.getMyFragment());
    }

    private void checkPageFragmentInFrame(PageFragmentWithSpan fragment) {
        List<WebElement> spans = fragment.getSpans();
        int sizeOfList = spans.size();
        Assert.assertEquals((long)4L, (long)sizeOfList);
        for (int i = 0; i < sizeOfList; ++i) {
            String text = fragment.getSpans().get(i).getText();
            Assert.assertTrue((!text.contains("fail") ? 1 : 0) != 0);
            Assert.assertEquals((Object)(i + 1), (Object)Integer.valueOf(text.trim()));
        }
    }

    private void checkWebElementInFrame(WebElement element) {
        String text = element.getText();
        this.checkWebElementInFrame(text);
    }

    private void checkWebElementInFrame(String elementText) {
        Assert.assertEquals((Object)EXPECTED_WEB_ELEMENT_IN_FRAME_TEXT, (Object)elementText);
    }

    private void checkWebElementInDefaultFrame(WebElement element) {
        this.testWebElementInFrameDefinedByIndex();
        Assert.assertEquals((Object)EXPECTED_WEB_ELEMENT_OUTSIDE_IFRAME_TEXT, (Object)this.page.getElementInDefaultFrame().getText());
    }
}

