/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.enricher;

import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.ftest.Resource;
import org.jboss.arquillian.graphene.ftest.Resources;
import org.jboss.arquillian.graphene.ftest.enricher.page.fragment.Panel;
import org.jboss.arquillian.graphene.ftest.enricher.page.fragment.TabPanel;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

@RunWith(value=Arquillian.class)
@RunAsClient
public class TestEnrichingContainerElement {
    @Drone
    private WebDriver browser;
    @FindBy(className="tabpanel")
    private TabPanel tabPanel;
    @ArquillianResource
    private URL contextRoot;

    @Deployment
    public static WebArchive createTestArchive() {
        return Resources.inCurrentPackage().all().buildWar("test.war");
    }

    @Before
    public void loadPage() {
        Resource.inCurrentPackage().find("container-elements.html").loadPage(this.browser, this.contextRoot);
    }

    @Test
    public void testTabPanelSwitching() {
        Panel tab3 = this.tabPanel.switchTo(2);
        ContentOfTab content = tab3.getContent(ContentOfTab.class);
        Assert.assertEquals((String)"The tab panel was not switched to third tab correctly!", (Object)"Content of the tab 3", (Object)content.getText().getText());
        Panel tab1 = this.tabPanel.switchTo(0);
        content = tab1.getContent(ContentOfTab.class);
        Assert.assertEquals((String)"The tab panel was not switched to first tab correctly!", (Object)"Content of the tab 1", (Object)content.getText().getText());
    }

    public static class ContentOfTab {
        @FindBy(className="tab-text")
        private WebElement text;

        public WebElement getText() {
            return this.text;
        }
    }
}

