/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.parallel;

import junit.framework.Assert;
import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.ftest.parallel.AbstractParallelTest;
import org.jboss.arquillian.graphene.javascript.JavaScript;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.graphene.page.document.Document;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import qualifier.Browser1;
import qualifier.Browser2;

@RunWith(value=Arquillian.class)
public class TestPageObjects
extends AbstractParallelTest {
    @Page
    @Browser1
    private SimplePage page1;
    @Page
    @Browser2
    private SimplePage page2;
    @Page
    private SimplePage pageDefault;

    @Test
    public void testNotNull() {
        Assert.assertNotNull((Object)this.page1);
        Assert.assertNotNull((Object)this.page2);
        Assert.assertNotNull((Object)this.pageDefault);
    }

    @Test
    public void testHeadersViaAttributes() {
        Assert.assertNotNull((Object)this.page1.header);
        Assert.assertNotNull((Object)this.page2.header);
        Assert.assertNotNull((Object)this.pageDefault.header);
        Assert.assertEquals((String)"Page 1", (String)this.page1.header.getText().trim());
        Assert.assertEquals((String)"Page 2", (String)this.page2.header.getText().trim());
        Assert.assertEquals((String)"Page Default", (String)this.pageDefault.header.getText().trim());
    }

    @Test
    public void testHeadersViaMethod() {
        Assert.assertNotNull((Object)this.page1.header());
        Assert.assertNotNull((Object)this.page2.header());
        Assert.assertNotNull((Object)this.pageDefault.header());
        Assert.assertEquals((String)"Page 1", (String)this.page1.header().getText().trim());
        Assert.assertEquals((String)"Page 2", (String)this.page2.header().getText().trim());
        Assert.assertEquals((String)"Page Default", (String)this.pageDefault.header().getText().trim());
    }

    @Test
    public void testDroneInPageObjects() {
        String url1 = this.browser1.getCurrentUrl();
        String url2 = this.browser2.getCurrentUrl();
        String urlDefault = this.browserDefault.getCurrentUrl();
        Assert.assertNotNull((Object)this.page1.browser());
        Assert.assertNotNull((Object)this.page2.browser());
        Assert.assertNotNull((Object)this.pageDefault.browser());
        Assert.assertEquals((String)url1, (String)this.page1.getCurrentURL());
        Assert.assertEquals((String)url2, (String)this.page2.getCurrentURL());
        Assert.assertEquals((String)urlDefault, (String)this.pageDefault.getCurrentURL());
    }

    @Test
    public void testJavaScriptInterfaceInPageObjects() {
        Assert.assertEquals((String)"Page 1", (String)this.page1.getHeaderTextViaJavaScriptInterface().trim());
        Assert.assertEquals((String)"Page 2", (String)this.page2.getHeaderTextViaJavaScriptInterface().trim());
        Assert.assertEquals((String)"Page Default", (String)this.pageDefault.getHeaderTextViaJavaScriptInterface().trim());
    }

    @Test
    public void testJavaScriptExecutorInPageObjects() {
        Assert.assertEquals((String)"Page 1", (String)this.page1.getTitleViaJavaScriptExecutor().trim());
        Assert.assertEquals((String)"Page 2", (String)this.page2.getTitleViaJavaScriptExecutor().trim());
        Assert.assertEquals((String)"Page Default", (String)this.pageDefault.getTitleViaJavaScriptExecutor().trim());
    }

    @Test
    public void testGrapheneContextQualifier() {
        Assert.assertEquals(Browser1.class, this.page1.getQualifier());
        Assert.assertEquals(Browser2.class, this.page2.getQualifier());
        Assert.assertEquals(Default.class, this.pageDefault.getQualifier());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimplePage {
        @FindBy(tagName="h1")
        private WebElement header;
        @JavaScript
        private Document document;
        @ArquillianResource
        private JavascriptExecutor javascriptExecutor;
        @ArquillianResource
        private GrapheneContext context;
        @Drone
        private WebDriver browser;

        public String getCurrentURL() {
            return this.browser.getCurrentUrl();
        }

        public String getTitleViaJavaScriptExecutor() {
            Object title = this.javascriptExecutor.executeScript("return document.title", new Object[0]);
            if (title == null) {
                return null;
            }
            return (String)title;
        }

        public String getHeaderTextViaJavaScriptInterface() {
            return ((WebElement)this.document.getElementsByTagName("h1").get(0)).getText().trim();
        }

        public Class<?> getQualifier() {
            return this.context.getQualifier();
        }

        public WebElement header() {
            return this.header;
        }

        public WebDriver browser() {
            return this.browser;
        }
    }
}

