/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.enricher;

import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.ftest.Resource;
import org.jboss.arquillian.graphene.ftest.Resources;
import org.jboss.arquillian.graphene.ftest.enricher.page.GrapheneElementWithInFrameAnnotationPage;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;

@RunWith(value=Arquillian.class)
@RunAsClient
public class TestInFrameFunctionalityWithGrapheneElement {
    @Drone
    private WebDriver browser;
    @Page
    private GrapheneElementWithInFrameAnnotationPage page;
    @ArquillianResource
    private URL contextRoot;
    private static final String EXPECTED_GRAPHENE_ELEMENT_IN_FRAME_TEXT = "not correct";

    @Deployment
    public static WebArchive createTestArchive() {
        return Resources.inCurrentPackage().all().buildWar("test.war");
    }

    @Before
    public void loadPage() {
        Resource.inCurrentPackage().find("inframe.html").loadPage(this.browser, this.contextRoot);
    }

    @Test
    public void testGrapheneElementShouldWorkWithInFrameAnnotation() {
        Assert.assertEquals((Object)EXPECTED_GRAPHENE_ELEMENT_IN_FRAME_TEXT, (Object)this.page.getSpan().getText());
    }

    @Test
    public void testGrapheneElementShouldWorkWithInFrameAnnotationMethodParam(@Page GrapheneElementWithInFrameAnnotationPage pageParam) {
        Assert.assertEquals((Object)EXPECTED_GRAPHENE_ELEMENT_IN_FRAME_TEXT, (Object)pageParam.getSpan().getText());
    }
}

