/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.guard;

import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.ftest.Resource;
import org.jboss.arquillian.graphene.ftest.Resources;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

@RunWith(value=Arquillian.class)
@RunAsClient
public class TestXHR2 {
    @ArquillianResource
    private URL contextRoot;
    @Drone
    private WebDriver browser;
    @FindBy
    private WebElement xhr1Trigger;
    @FindBy
    private WebElement xhr2Trigger;
    @FindBy
    private WebElement response1;
    @FindBy
    private WebElement response2;

    @Deployment
    public static WebArchive createTestArchive() {
        return Resources.inCurrentPackage().all().buildWar("test.war");
    }

    @Before
    public void loadPage() {
        Resource.inCurrentPackage().find("xhr2.html").loadPage(this.browser, this.contextRoot);
    }

    @Test
    public void test() {
        ((WebElement)Graphene.guardAjax((Object)this.xhr2Trigger)).click();
        String response2Text = this.response2.getText();
        ((WebElement)Graphene.guardAjax((Object)this.xhr1Trigger)).click();
        String response1Text = this.response1.getText();
        Assert.assertEquals((Object)"XHR 1 request successfull", (Object)response1Text);
        Assert.assertEquals((Object)"XHR 2 request successfull", (Object)response2Text);
    }
}

