/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.parallel;

import junit.framework.Assert;
import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.ftest.parallel.AbstractParallelTest;
import org.jboss.arquillian.graphene.javascript.JavaScript;
import org.jboss.arquillian.graphene.page.document.Document;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import qualifier.Browser1;
import qualifier.Browser2;

@RunWith(value=Arquillian.class)
public class TestPageFragments
extends AbstractParallelTest {
    @Browser1
    @FindBy(tagName="body")
    private PageFragment pageFragment1;
    @Browser2
    @FindBy(tagName="body")
    private PageFragment pageFragment2;
    @FindBy(tagName="body")
    private PageFragment pageFragmentDefault;

    @Test
    public void testNotNull() {
        Assert.assertNotNull((Object)this.pageFragment1);
        Assert.assertNotNull((Object)this.pageFragment2);
        Assert.assertNotNull((Object)this.pageFragmentDefault);
    }

    @Test
    public void testHeadersViaAttributes() {
        Assert.assertNotNull((Object)this.pageFragment1.header);
        Assert.assertNotNull((Object)this.pageFragment1.header);
        Assert.assertNotNull((Object)this.pageFragmentDefault.header);
        Assert.assertEquals((String)"Page 1", (String)this.pageFragment1.header.getText().trim());
        Assert.assertEquals((String)"Page 2", (String)this.pageFragment2.header.getText().trim());
        Assert.assertEquals((String)"Page Default", (String)this.pageFragmentDefault.header.getText().trim());
    }

    @Test
    public void testHeadersViaMethod() {
        Assert.assertNotNull((Object)this.pageFragment1.header());
        Assert.assertNotNull((Object)this.pageFragment2.header());
        Assert.assertNotNull((Object)this.pageFragmentDefault.header());
        Assert.assertEquals((String)"Page 1", (String)this.pageFragment1.header().getText().trim());
        Assert.assertEquals((String)"Page 2", (String)this.pageFragment2.header().getText().trim());
        Assert.assertEquals((String)"Page Default", (String)this.pageFragmentDefault.header().getText().trim());
    }

    @Test
    public void testDroneInPageFragments() {
        String url1 = this.browser1.getCurrentUrl();
        String url2 = this.browser2.getCurrentUrl();
        String urlDefault = this.browserDefault.getCurrentUrl();
        Assert.assertNotNull((Object)this.pageFragment1.browser());
        Assert.assertNotNull((Object)this.pageFragment2.browser());
        Assert.assertNotNull((Object)this.pageFragmentDefault.browser());
        Assert.assertEquals((String)url1, (String)this.pageFragment1.getCurrentURL());
        Assert.assertEquals((String)url2, (String)this.pageFragment2.getCurrentURL());
        Assert.assertEquals((String)urlDefault, (String)this.pageFragmentDefault.getCurrentURL());
    }

    @Test
    public void testJavaScriptInterfaceInPageFragments() {
        Assert.assertEquals((String)"Page 1", (String)this.pageFragment1.getHeaderTextViaJavaScriptInterface().trim());
        Assert.assertEquals((String)"Page 2", (String)this.pageFragment2.getHeaderTextViaJavaScriptInterface().trim());
        Assert.assertEquals((String)"Page Default", (String)this.pageFragmentDefault.getHeaderTextViaJavaScriptInterface().trim());
    }

    @Test
    public void testJavaScriptExecutorInPageFragments() {
        Assert.assertEquals((String)"Page 1", (String)this.pageFragment1.getTitleViaJavaScriptExecutor().trim());
        Assert.assertEquals((String)"Page 2", (String)this.pageFragment2.getTitleViaJavaScriptExecutor().trim());
        Assert.assertEquals((String)"Page Default", (String)this.pageFragmentDefault.getTitleViaJavaScriptExecutor().trim());
    }

    @Test
    public void testGrapheneContextQualifier() {
        Assert.assertEquals(Browser1.class, this.pageFragment1.getQualifier());
        Assert.assertEquals(Browser2.class, this.pageFragment2.getQualifier());
        Assert.assertEquals(Default.class, this.pageFragmentDefault.getQualifier());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PageFragment {
        @JavaScript
        private Document document;
        @Drone
        private WebDriver browser;
        @FindBy(tagName="h1")
        private WebElement header;
        @ArquillianResource
        private JavascriptExecutor javascriptExecutor;
        @ArquillianResource
        private GrapheneContext context;

        public String getCurrentURL() {
            return this.browser.getCurrentUrl();
        }

        public String getHeaderTextViaJavaScriptInterface() {
            return ((WebElement)this.document.getElementsByTagName("h1").get(0)).getText().trim();
        }

        public Class<?> getQualifier() {
            return this.context.getQualifier();
        }

        public String getTitleViaJavaScriptExecutor() {
            Object title = this.javascriptExecutor.executeScript("return document.title", new Object[0]);
            if (title == null) {
                return null;
            }
            return (String)title;
        }

        public WebElement header() {
            return this.header;
        }

        public WebDriver browser() {
            return this.browser;
        }
    }
}

