/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.enricher;

import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.ftest.Resources;
import org.jboss.arquillian.graphene.ftest.enricher.page.fragment.PageFragmentExtendingPageFragment;
import org.jboss.arquillian.graphene.ftest.enricher.page.fragment.PageFragmentImplementingGrapheneElement;
import org.jboss.arquillian.graphene.ftest.enricher.page.fragment.PageFragmentImplementingWebElement;
import org.jboss.arquillian.graphene.page.InitialPage;
import org.jboss.arquillian.graphene.page.Location;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.FindBy;

@RunWith(value=Arquillian.class)
@RunAsClient
public class TestDelegatingPageFragment {
    @Drone
    private WebDriver browser;
    @ArquillianResource
    private URL contextRoot;
    @Page
    private TestPage page;
    private static final String pageLocation = "org/jboss/arquillian/graphene/ftest/enricher/delegating-pagefragment.html";

    @Deployment
    public static WebArchive createTestArchive() {
        return Resources.inCurrentPackage().find("delegating-pagefragment.html").buildWar("deployment.war");
    }

    @Test
    public void testPageFragmentMethodIsDelegatingCorrectly() {
        this.browser.get(this.contextRoot + pageLocation);
        this.testPageFragment(this.page.getInputFragment());
    }

    @Test
    public void testPageFragmentMethodIsDelegatingCorrectlyMethodParam(@Page TestPage pageParam) {
        this.browser.get(this.contextRoot + pageLocation);
        this.testPageFragment(pageParam.getInputFragment());
    }

    @Test
    public void testExtendingPageFragmentMethodIsDelegatingCorrectly() {
        this.browser.get(this.contextRoot + pageLocation);
        this.testPageFragment(this.page.getInputExtendedFragment());
    }

    @Test
    public void testExtendingPageFragmentMethodIsDelegatingCorrectlyMethodParam(@Page TestPage pageParam) {
        this.browser.get(this.contextRoot + pageLocation);
        this.testPageFragment(pageParam.getInputExtendedFragment());
    }

    @Test
    public void testPageFragmentImplementingGrapheneElement() {
        this.checkPageFragmentImplementingGrapheneElement(this.page);
    }

    @Test
    public void testPageFragmentImplementingGrapheneElementMethodParam(@Page TestPage pageParam) {
        this.checkPageFragmentImplementingGrapheneElement(pageParam);
    }

    @Test
    public void testPageFragmentFromInitialPageIsDelegatingCorrectly(@InitialPage TestPage testedPage) {
        this.testPageFragment(testedPage.getInputFragment());
    }

    @Test(expected=NoSuchElementException.class)
    public void testPageFragmentUnwrapsInvocationTargetException() {
        this.page.notExisting.isDisplayed();
    }

    @Test(expected=NoSuchElementException.class)
    public void testPageFragmentUnwrapsInvocationTargetExceptionMethodParam(@Page TestPage pageParam) {
        pageParam.notExisting.isDisplayed();
    }

    private void checkPageFragmentImplementingGrapheneElement(TestPage pageToCheck) {
        this.browser.get(this.contextRoot + pageLocation);
        Assert.assertTrue((boolean)pageToCheck.outputFragment.isPresent());
        Assert.assertEquals((Object)"foo-bar", (Object)pageToCheck.outputFragment.getStyleClass());
        Assert.assertEquals((Object)pageToCheck.outputFragment.getOutputText(), (Object)pageToCheck.outputFragment.getText());
    }

    private void testPageFragment(PageFragmentImplementingWebElement fragment) {
        String expectedText = "test";
        fragment.sendKeys(new CharSequence[]{expectedText});
        Assert.assertEquals((Object)expectedText, (Object)fragment.getInputText());
        Assert.assertEquals((Object)"foo-bar", (Object)fragment.getStyleClass());
    }

    @Location(value="org/jboss/arquillian/graphene/ftest/enricher/delegating-pagefragment.html")
    public class TestPage {
        @FindBy(tagName="input")
        private PageFragmentImplementingWebElement inputFragment;
        @FindBy(tagName="p")
        private PageFragmentImplementingGrapheneElement outputFragment;
        @FindBy(id="notExisting")
        private PageFragmentImplementingWebElement notExisting;
        @FindBy(className="foo-bar")
        private PageFragmentExtendingPageFragment inputExtendedFragment;

        public PageFragmentImplementingWebElement getInputFragment() {
            return this.inputFragment;
        }

        public PageFragmentExtendingPageFragment getInputExtendedFragment() {
            return this.inputExtendedFragment;
        }
    }
}

