/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.enricher;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.enricher.FieldAccessValidatorEnricher;
import org.jboss.arquillian.graphene.ftest.Resource;
import org.jboss.arquillian.graphene.ftest.Resources;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;

@RunWith(value=Arquillian.class)
@RunAsClient
public class TestFieldAccessValidatorEnricher {
    @Drone
    private WebDriver browser;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @ArquillianResource
    private URL contextRoot;
    private static final Logger LOGGER = Logger.getLogger(FieldAccessValidatorEnricher.class.getName());
    private static final String PART_OF_WARNING = "Public field";
    private static Handler logHandler;
    private static ByteArrayOutputStream logOutput;

    @Deployment
    public static WebArchive createTestArchive() {
        return Resources.inCurrentPackage().all().buildWar("test.war");
    }

    @Before
    public void loadPage() {
        Resource.inCurrentPackage().find("sample.html").loadPage(this.browser, this.contextRoot);
    }

    @BeforeClass
    public static void redirectLoggerOutput() throws IOException {
        logOutput = new ByteArrayOutputStream();
        logHandler = new StreamHandler(logOutput, new SimpleFormatter());
        logHandler.setLevel(Level.ALL);
        LOGGER.addHandler(logHandler);
    }

    @Test
    public void testFooBar() throws IOException {
        try {
            logHandler.flush();
            Assert.assertFalse((String)"There should be no warnign produced by FieldAccessValidatorEnricher!", (boolean)logOutput.toString().contains(PART_OF_WARNING));
        }
        finally {
            logHandler.close();
            LOGGER.removeHandler(logHandler);
        }
    }
}

