/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.enricher;

import java.io.IOException;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.ftest.Resource;
import org.jboss.arquillian.graphene.ftest.Resources;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.FindBy;

@RunWith(value=Arquillian.class)
@RunAsClient
public class TestExceptionsAndErrorsOnPageFragmentsAndObjects {
    @Drone
    private WebDriver browser;
    @ArquillianResource
    private URL contextRoot;
    @FindBy(css="body")
    private PageOrFragmentThrowingAssertionError fragment;
    @Page
    private PageOrFragmentThrowingAssertionError page;

    @Deployment
    public static WebArchive createTestArchive() {
        return Resources.inCurrentPackage().all().buildWar("test.war");
    }

    @Before
    public void loadPage() {
        Resource.inCurrentPackage().find("sample.html").loadPage(this.browser, this.contextRoot);
    }

    @Test(expected=AssertionError.class)
    public void testAssertionErrorFromPageFragmentIsNotWrapped() {
        this.fragment.throwAssertionError();
    }

    @Test(expected=AssertionError.class)
    public void testAssertionErrorFromPageObjectIsNotWrapped() {
        this.page.throwAssertionError();
    }

    @Test(expected=IOException.class)
    public void testCheckedExceptionFromPageFragmentIsNotWrapped() throws Exception {
        this.fragment.throwCheckedException();
    }

    @Test(expected=IOException.class)
    public void testCheckedExceptionFromPageObjectIsNotWrapped() throws Exception {
        this.page.throwCheckedException();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRuntimeExceptionFromPageFragmentIsNotWrapped() {
        this.fragment.throwRuntimeException();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRuntimeExceptionFromPageObjectIsNotWrapped() {
        this.page.throwRuntimeException();
    }

    public static class PageOrFragmentThrowingAssertionError {
        public void throwAssertionError() {
            throw new AssertionError((Object)"This is assertion error!");
        }

        public void throwCheckedException() throws Exception {
            throw new IOException("this is checked exception");
        }

        public void throwRuntimeException() {
            throw new IllegalArgumentException("this is runtime exception");
        }
    }
}

