/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.enricher;

import java.net.URL;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.ftest.Resource;
import org.jboss.arquillian.graphene.ftest.Resources;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.FindBys;

@RunWith(value=Arquillian.class)
@RunAsClient
public class TestInitializeFindBys {
    @Drone
    private WebDriver browser;
    @ArquillianResource
    private URL contextRoot;
    private static final String EXPECTED = "correct";
    @FindBys(value={@FindBy(css="#root"), @FindBy(tagName="div"), @FindBy(tagName="span")})
    private WebElement element;
    @FindBys(value={@FindBy(css="#root"), @FindBy(css=".list")})
    private List<WebElement> elements;

    @Deployment
    public static WebArchive createTestArchive() {
        return Resources.inCurrentPackage().all().buildWar("test.war");
    }

    @Before
    public void loadPage() {
        Resource.inCurrentPackage().find("findbys.html").loadPage(this.browser, this.contextRoot);
    }

    @Test
    public void testWebDriverFindBysOverWebElementInitialized() {
        this.assertFindBysOverWebElement(this.element);
    }

    private void assertFindBysOverWebElement(WebElement element) {
        Assert.assertNotNull((String)"Element cannot be null! @FindBys was not initialized correctly!", (Object)element);
        Assert.assertEquals((String)"Element location determined by @FindBys was not correct!", (Object)EXPECTED, (Object)element.getText());
    }

    @Test
    public void testWebDriverFindBysOverListInitialized() {
        this.assertFindBysOverList(this.elements);
    }

    private void assertFindBysOverList(List<WebElement> elements) {
        Assert.assertNotNull(elements);
        for (int i = 1; i < 4; ++i) {
            Assert.assertEquals((long)i, (long)Integer.valueOf(elements.get(i - 1).getText()).intValue());
        }
    }
}

