/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.page.extension;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import junit.framework.Assert;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.context.ExtendedGrapheneContext;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.ftest.Resource;
import org.jboss.arquillian.graphene.ftest.Resources;
import org.jboss.arquillian.graphene.page.extension.PageExtensionRegistry;
import org.jboss.arquillian.graphene.spi.javascript.JavaScript;
import org.jboss.arquillian.graphene.spi.page.PageExtension;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.openqa.selenium.WebDriver;

@RunWith(value=Arquillian.class)
@RunAsClient
public class PageExtensionTestCase {
    @ArquillianResource
    private URL contextRoot;
    @Drone
    private WebDriver browser;
    @ArquillianResource
    private GrapheneContext context;

    @Deployment
    public static WebArchive createTestArchive() {
        return Resources.inCurrentPackage().all().buildWar("test.war");
    }

    @Before
    public void loadPage() {
        Resource.inCurrentPackage().find("sample.html").loadPage(this.browser, this.contextRoot);
    }

    @Test
    public void testCorrectInstallation() {
        PageExtension pageExtensionMock = (PageExtension)Mockito.mock(PageExtension.class);
        Mockito.when((Object)pageExtensionMock.getExtensionScript()).thenReturn((Object)JavaScript.fromString((String)"document.Graphene = {};"));
        Mockito.when((Object)pageExtensionMock.getInstallationDetectionScript()).thenReturn((Object)JavaScript.fromString((String)"return (typeof document.Graphene != 'undefined');"));
        Mockito.when((Object)pageExtensionMock.getRequired()).thenReturn((Object)Collections.EMPTY_LIST);
        PageExtensionRegistry registry = this.context().getPageExtensionRegistry();
        registry.register(new PageExtension[]{pageExtensionMock});
        this.context().getPageExtensionInstallatorProvider().installator(pageExtensionMock.getName()).install();
    }

    private ExtendedGrapheneContext context() {
        return (ExtendedGrapheneContext)this.context;
    }

    @Test(expected=IllegalStateException.class)
    public void testIncorrectInstallation() {
        PageExtension pageExtensionMock = (PageExtension)Mockito.mock(PageExtension.class);
        Mockito.when((Object)pageExtensionMock.getExtensionScript()).thenReturn((Object)JavaScript.fromString((String)"var Graphene = {};"));
        Mockito.when((Object)pageExtensionMock.getInstallationDetectionScript()).thenReturn((Object)JavaScript.fromString((String)"return (typeof Graphene != 'undefined');"));
        Mockito.when((Object)pageExtensionMock.getRequired()).thenReturn((Object)Collections.EMPTY_LIST);
        PageExtensionRegistry registry = this.context().getPageExtensionRegistry();
        registry.register(new PageExtension[]{pageExtensionMock});
        this.context().getPageExtensionInstallatorProvider().installator(pageExtensionMock.getName()).install();
    }

    @Test
    public void testInstallationWithRequirements() {
        PageExtension pageExtensionMock = (PageExtension)Mockito.mock(PageExtension.class);
        Mockito.when((Object)pageExtensionMock.getExtensionScript()).thenReturn((Object)JavaScript.fromString((String)"document.Graphene2 = document.Graphene1 + 1;"));
        Mockito.when((Object)pageExtensionMock.getInstallationDetectionScript()).thenReturn((Object)JavaScript.fromString((String)"return ((typeof document.Graphene2 != 'undefined') && document.Graphene2 == 2);"));
        ArrayList<String> requirements = new ArrayList<String>();
        requirements.add(SimplePageExtension.class.getName());
        Mockito.when((Object)pageExtensionMock.getRequired()).thenReturn(requirements);
        PageExtensionRegistry registry = this.context().getPageExtensionRegistry();
        registry.register(new PageExtension[]{new SimplePageExtension()});
        registry.register(new PageExtension[]{pageExtensionMock});
        this.context().getPageExtensionInstallatorProvider().installator(pageExtensionMock.getName()).install();
        Assert.assertTrue((boolean)this.context().getPageExtensionInstallatorProvider().installator(SimplePageExtension.class.getName()).isInstalled());
        Assert.assertTrue((boolean)this.context().getPageExtensionInstallatorProvider().installator(pageExtensionMock.getName()).isInstalled());
    }

    @Test(expected=IllegalStateException.class)
    public void testInstallationWithCyclicRequirements() {
        PageExtension pageExtensionMock = (PageExtension)Mockito.mock(PageExtension.class);
        Mockito.when((Object)pageExtensionMock.getExtensionScript()).thenReturn((Object)JavaScript.fromString((String)"document.Graphene2 = document.Graphene1 + 1;"));
        Mockito.when((Object)pageExtensionMock.getInstallationDetectionScript()).thenReturn((Object)JavaScript.fromString((String)"return ((typeof document.Graphene2 != 'undefined') && document.Graphene2 == 2);"));
        ArrayList<String> requirements = new ArrayList<String>();
        requirements.add(SimplePageExtension.class.getName());
        requirements.add(CyclicPageExtension1.class.getName());
        requirements.add(CyclicPageExtension2.class.getName());
        Mockito.when((Object)pageExtensionMock.getRequired()).thenReturn(requirements);
        PageExtensionRegistry registry = this.context().getPageExtensionRegistry();
        registry.register(new PageExtension[]{new SimplePageExtension()});
        registry.register(new PageExtension[]{pageExtensionMock});
        registry.register(new PageExtension[]{new CyclicPageExtension1()});
        registry.register(new PageExtension[]{new CyclicPageExtension2()});
        this.context().getPageExtensionInstallatorProvider().installator(pageExtensionMock.getName()).install();
    }

    private static class CyclicPageExtension2
    implements PageExtension {
        private CyclicPageExtension2() {
        }

        public JavaScript getExtensionScript() {
            return JavaScript.fromString((String)"document.Cyclic2 = 1;");
        }

        public JavaScript getInstallationDetectionScript() {
            return JavaScript.fromString((String)"return ((typeof document.Cyclic2 != 'undefined') && document.Cyclic2 == 1);");
        }

        public Collection<String> getRequired() {
            ArrayList<String> required = new ArrayList<String>();
            required.add(CyclicPageExtension1.class.getName());
            return required;
        }

        public String getName() {
            return this.getClass().getName();
        }
    }

    private static class CyclicPageExtension1
    implements PageExtension {
        private CyclicPageExtension1() {
        }

        public JavaScript getExtensionScript() {
            return JavaScript.fromString((String)"document.Cyclic1 = 1;");
        }

        public JavaScript getInstallationDetectionScript() {
            return JavaScript.fromString((String)"return ((typeof document.Cyclic1 != 'undefined') && document.Cyclic1 == 1);");
        }

        public Collection<String> getRequired() {
            ArrayList<String> required = new ArrayList<String>();
            required.add(CyclicPageExtension2.class.getName());
            return required;
        }

        public String getName() {
            return this.getClass().getName();
        }
    }

    private static class SimplePageExtension
    implements PageExtension {
        private SimplePageExtension() {
        }

        public JavaScript getExtensionScript() {
            return JavaScript.fromString((String)"document.Graphene1 = 1;");
        }

        public JavaScript getInstallationDetectionScript() {
            return JavaScript.fromString((String)"return ((typeof document.Graphene1 != 'undefined') && document.Graphene1 == 1);");
        }

        public Collection<String> getRequired() {
            return Collections.EMPTY_LIST;
        }

        public String getName() {
            return this.getClass().getName();
        }
    }
}

