/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.parallel;

import junit.framework.Assert;
import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.ftest.parallel.AbstractParallelTest;
import org.jboss.arquillian.graphene.javascript.JavaScript;
import org.jboss.arquillian.graphene.page.document.Document;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;
import qualifier.Browser1;
import qualifier.Browser2;

@RunWith(value=Arquillian.class)
public class TestTestClass
extends AbstractParallelTest {
    @Browser1
    @JavaScript
    private Document document1;
    @Browser2
    @JavaScript
    private Document document2;
    @JavaScript
    private Document documentDefault;
    @Browser1
    @ArquillianResource
    private JavascriptExecutor javaScriptExecutor1;
    @Browser2
    @ArquillianResource
    private JavascriptExecutor javaScriptExecutor2;
    @ArquillianResource
    private JavascriptExecutor javaScriptExecutorDefault;
    @Browser1
    @ArquillianResource
    private GrapheneContext context1;
    @Browser2
    @ArquillianResource
    private GrapheneContext context2;
    @ArquillianResource
    private GrapheneContext contextDefault;

    @Test
    public void testJavaScriptNotNull() {
        Assert.assertNotNull((Object)this.document1);
        Assert.assertNotNull((Object)this.document2);
        Assert.assertNotNull((Object)this.documentDefault);
    }

    @Test
    public void testDroneNotNull() {
        Assert.assertNotNull((Object)this.browser1);
        Assert.assertNotNull((Object)this.browser2);
        Assert.assertNotNull((Object)this.browserDefault);
    }

    @Test
    public void testArquillianResourcesNotNull() {
        Assert.assertNotNull((Object)this.javaScriptExecutor1);
        Assert.assertNotNull((Object)this.javaScriptExecutor2);
        Assert.assertNotNull((Object)this.javaScriptExecutorDefault);
    }

    @Test
    public void testJavaScriptInterfaceInvocation() {
        Assert.assertEquals((int)1, (int)this.document1.getElementsByTagName("h1").size());
        Assert.assertEquals((int)1, (int)this.document2.getElementsByTagName("h1").size());
        Assert.assertEquals((int)1, (int)this.documentDefault.getElementsByTagName("h1").size());
        Assert.assertEquals((String)"Page 1", (String)((WebElement)this.document1.getElementsByTagName("h1").get(0)).getText());
        Assert.assertEquals((String)"Page 2", (String)((WebElement)this.document2.getElementsByTagName("h1").get(0)).getText());
        Assert.assertEquals((String)"Page Default", (String)((WebElement)this.documentDefault.getElementsByTagName("h1").get(0)).getText());
    }

    @Test
    public void testJavaScriptExecutorInvocation() {
        String title1 = (String)this.javaScriptExecutor1.executeScript("return document.title", new Object[0]);
        String title2 = (String)this.javaScriptExecutor2.executeScript("return document.title", new Object[0]);
        String titleDefault = (String)this.javaScriptExecutorDefault.executeScript("return document.title", new Object[0]);
        Assert.assertEquals((String)"Page 1", (String)title1);
        Assert.assertEquals((String)"Page 2", (String)title2);
        Assert.assertEquals((String)"Page Default", (String)titleDefault);
    }

    @Test
    public void testOpenPage() {
        WebElement header1 = this.browser1.findElement(By.tagName((String)"h1"));
        WebElement header2 = this.browser2.findElement(By.tagName((String)"h1"));
        WebElement headerDefault = this.browserDefault.findElement(By.tagName((String)"h1"));
        Assert.assertNotNull((Object)header1);
        Assert.assertNotNull((Object)header2);
        Assert.assertNotNull((Object)headerDefault);
        Assert.assertEquals((String)"Page 1", (String)header1.getText().trim());
        Assert.assertEquals((String)"Page 2", (String)header2.getText().trim());
        Assert.assertEquals((String)"Page Default", (String)headerDefault.getText().trim());
    }

    @Test
    public void testGrapheneContextQualifier() {
        Assert.assertEquals(Browser1.class, (Object)this.context1.getQualifier());
        Assert.assertEquals(Browser2.class, (Object)this.context2.getQualifier());
        Assert.assertEquals(Default.class, (Object)this.contextDefault.getQualifier());
    }
}

