/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.condition;

import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.ftest.Resource;
import org.jboss.arquillian.graphene.ftest.Resources;
import org.jboss.arquillian.graphene.wait.IsAttributeBuilder;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.jboss.arquillian.graphene.wait.StringMatcher;
import org.jboss.arquillian.junit.ArquillianTest;
import org.jboss.arquillian.junit.ArquillianTestClass;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.Select;

@RunAsClient
public class ConditionsJUnitRulesTestCase {
    @ClassRule
    public static ArquillianTestClass arquillianTestClass = new ArquillianTestClass();
    @Rule
    public ArquillianTest arquillianTest = new ArquillianTest();
    @Drone
    private WebDriver browser;
    private static final By BY_HEADER = By.id((String)"header");
    private static final By BY_OPTION1 = By.id((String)"option1");
    private static final By BY_HIDE_BUTTON = By.id((String)"hide");
    private static final By BY_APPEAR_BUTTON = By.id((String)"appear");
    @FindBy(id="appear")
    private WebElement appearButton;
    @FindBy(id="header")
    private WebElement header;
    @FindBy(id="hide")
    private WebElement hideButton;
    @FindBy(id="idInput")
    private WebElement idInput;
    @FindBy(id="option1")
    private WebElement option1;
    @FindBy(id="select")
    private WebElement select;
    @FindBy(id="textInput")
    private WebElement textInput;
    @FindBy(id="submit")
    private WebElement updateButton;
    @ArquillianResource
    private URL contextRoot;

    @Deployment
    public static WebArchive createTestArchive() {
        return Resources.inCurrentPackage().all().buildWar("test.war");
    }

    @Before
    public void loadPage() {
        Resource.inCurrentPackage().find("sample.html").loadPage(this.browser, this.contextRoot);
    }

    @Test
    public void testAttributeIsPresent() {
        this.hideButton.click();
        Graphene.waitModel().until().element(this.header).attribute("style").is().present();
        this.appearButton.click();
        ((IsAttributeBuilder)Graphene.waitModel().until().element(this.header).attribute("style").is().not()).present();
    }

    @Test
    public void testAttributeValueContains() {
        this.textInput.clear();
        ((StringMatcher)Graphene.waitModel().until().element(this.textInput).value().not()).contains("Tested");
        this.textInput.sendKeys(new CharSequence[]{"Tested Header"});
        Graphene.waitModel().until().element(this.textInput).value().contains("Tested");
    }

    @Test
    public void testAttributeValueEquals() {
        this.textInput.clear();
        this.textInput.sendKeys(new CharSequence[]{"Tested"});
        ((StringMatcher)Graphene.waitModel().until().element(this.textInput).value().not()).equalTo("Tested Header");
        this.textInput.sendKeys(new CharSequence[]{" Header"});
        Graphene.waitModel().until().element(this.textInput).value().equalTo("Tested Header");
    }

    @Test
    public void testAttributeValueEqualsIgnoreCase() {
        this.textInput.clear();
        this.textInput.sendKeys(new CharSequence[]{"Tested"});
        ((StringMatcher)Graphene.waitModel().until().element(this.textInput).value().not()).equalToIgnoreCase("tEsTeD HEADER");
        this.textInput.sendKeys(new CharSequence[]{" Header"});
        Graphene.waitModel().until().element(this.textInput).value().equalToIgnoreCase("tEsTeD HEADER");
    }

    @Test
    public void testAttributeValueMatches() {
        this.textInput.clear();
        this.textInput.sendKeys(new CharSequence[]{"Tested"});
        ((StringMatcher)Graphene.waitModel().until().element(this.textInput).value().not()).matches("[tT]este. [hH]ea.er");
        this.textInput.sendKeys(new CharSequence[]{" Header"});
        Graphene.waitModel().until().element(this.textInput).value().matches("[tT]este. [hH]ea.er");
    }

    @Test
    public void testElementIsPresent() {
        this.idInput.clear();
        this.idInput.sendKeys(new CharSequence[]{"header2"});
        this.updateButton.click();
        ((IsElementBuilder)Graphene.waitModel((WebDriver)this.browser).until().element(this.header).is().not()).present();
        this.idInput.clear();
        this.idInput.sendKeys(new CharSequence[]{"header"});
        this.updateButton.click();
        Graphene.waitModel((WebDriver)this.browser).until().element(this.header).is().present();
    }

    @Test
    public void testElementIsPresentWithBy() {
        this.idInput.clear();
        this.idInput.sendKeys(new CharSequence[]{"header2"});
        this.updateButton.click();
        ((IsElementBuilder)Graphene.waitModel((WebDriver)this.browser).until().element(BY_HEADER).is().not()).present();
        this.idInput.clear();
        this.idInput.sendKeys(new CharSequence[]{"header"});
        this.updateButton.click();
        Graphene.waitModel((WebDriver)this.browser).until().element(BY_HEADER).is().present();
    }

    @Test
    public void testElementIsSelected() {
        new Select(this.select).selectByIndex(0);
        Graphene.waitModel().until().element(this.option1).is().selected();
        new Select(this.select).selectByIndex(1);
        ((IsElementBuilder)Graphene.waitModel().until().element(this.option1).is().not()).selected();
    }

    @Test
    public void testElementIsSelectedWithBy() {
        new Select(this.select).selectByIndex(0);
        Graphene.waitModel().until().element(BY_OPTION1).is().selected();
        new Select(this.select).selectByIndex(1);
        ((IsElementBuilder)Graphene.waitModel().until().element(BY_OPTION1).is().not()).selected();
    }

    @Test
    public void testElementIsVisible() {
        this.hideButton.click();
        ((IsElementBuilder)Graphene.waitModel().until().element(this.header).is().not()).visible();
        this.appearButton.click();
        Graphene.waitModel().until().element(this.header).is().visible();
    }

    @Test
    public void testElementIsVisibleWithBy() {
        this.hideButton.click();
        ((IsElementBuilder)Graphene.waitModel().until().element(BY_HEADER).is().not()).visible();
        this.appearButton.click();
        Graphene.waitModel().until().element(BY_HEADER).is().visible();
    }

    @Test
    public void testElementIsClickable() {
        Graphene.waitModel().until().element(this.hideButton).is().clickable();
        this.hideButton.click();
        ((IsElementBuilder)Graphene.waitModel().until().element(this.hideButton).is().not()).clickable();
        Graphene.waitModel().until().element(this.appearButton).is().clickable();
        this.appearButton.click();
        ((IsElementBuilder)Graphene.waitModel().until().element(this.appearButton).is().not()).clickable();
    }

    @Test
    public void testElementIsClickableWithBy() {
        Graphene.waitModel().until().element(BY_HIDE_BUTTON).is().clickable();
        this.hideButton.click();
        ((IsElementBuilder)Graphene.waitModel().until().element(BY_HIDE_BUTTON).is().not()).clickable();
        Graphene.waitModel().until().element(BY_APPEAR_BUTTON).is().clickable();
        this.appearButton.click();
        ((IsElementBuilder)Graphene.waitModel().until().element(BY_APPEAR_BUTTON).is().not()).clickable();
    }

    @Test
    public void testElementTextContains() {
        this.textInput.clear();
        this.textInput.sendKeys(new CharSequence[]{"florence and the machine"});
        this.updateButton.click();
        Graphene.waitModel().until().element(this.header).text().contains("machine");
        this.textInput.clear();
        this.textInput.sendKeys(new CharSequence[]{"Tested Header"});
        this.updateButton.click();
        ((StringMatcher)Graphene.waitModel().until().element(this.header).text().not()).contains("machine");
    }

    @Test
    public void testElementTextContainsWithBy() {
        this.textInput.clear();
        this.textInput.sendKeys(new CharSequence[]{"florence and the machine"});
        this.updateButton.click();
        Graphene.waitModel().until().element(BY_HEADER).text().contains("machine");
        this.textInput.clear();
        this.textInput.sendKeys(new CharSequence[]{"Tested Header"});
        this.updateButton.click();
        ((StringMatcher)Graphene.waitModel().until().element(BY_HEADER).text().not()).contains("machine");
    }

    @Test
    public void testElementTextEquals() {
        this.textInput.clear();
        this.textInput.sendKeys(new CharSequence[]{"florence and the machine"});
        this.updateButton.click();
        Graphene.waitModel().until().element(this.header).text().equalTo("florence and the machine");
        this.textInput.sendKeys(new CharSequence[]{"Tested Header"});
        this.updateButton.click();
        ((StringMatcher)Graphene.waitModel().until().element(this.header).text().not()).equalTo("florence and the machine");
    }

    @Test
    public void testElementTextEqualsWithBy() {
        this.textInput.clear();
        this.textInput.sendKeys(new CharSequence[]{"florence and the machine"});
        this.updateButton.click();
        Graphene.waitModel().until().element(BY_HEADER).text().equalTo("florence and the machine");
        this.textInput.sendKeys(new CharSequence[]{"Tested Header"});
        this.updateButton.click();
        ((StringMatcher)Graphene.waitModel().until().element(BY_HEADER).text().not()).equalTo("florence and the machine");
    }

    @Test
    public void testElementTextEqualsIgnoreCase() {
        this.textInput.clear();
        this.textInput.sendKeys(new CharSequence[]{"florence and the machine"});
        this.updateButton.click();
        Graphene.waitModel().until().element(this.header).text().equalToIgnoreCase("FLORENCE aNd THE machIne");
        this.textInput.sendKeys(new CharSequence[]{"Tested Header"});
        this.updateButton.click();
        ((StringMatcher)Graphene.waitModel().until().element(this.header).text().not()).equalToIgnoreCase("FLORENCE aNd THE machIne");
    }

    @Test
    public void testElementTextEqualsIgnoreCaseWithBy() {
        this.textInput.clear();
        this.textInput.sendKeys(new CharSequence[]{"florence and the machine"});
        this.updateButton.click();
        Graphene.waitModel().until().element(BY_HEADER).text().equalToIgnoreCase("FLORENCE aNd THE machIne");
        this.textInput.sendKeys(new CharSequence[]{"Tested Header"});
        this.updateButton.click();
        ((StringMatcher)Graphene.waitModel().until().element(BY_HEADER).text().not()).equalToIgnoreCase("FLORENCE aNd THE machIne");
    }

    @Test
    public void testElementTextMatches() {
        this.textInput.clear();
        this.textInput.sendKeys(new CharSequence[]{"florence and the machine"});
        this.updateButton.click();
        Graphene.waitModel().until().element(this.header).text().matches("[fF]lorenc. and (the)? [mM]a.hine");
        this.textInput.sendKeys(new CharSequence[]{"Tested Header"});
        this.updateButton.click();
        ((StringMatcher)Graphene.waitModel().until().element(this.header).text().not()).matches("[fF]lorenc. and (the)? [mM]a.hine");
    }

    @Test
    public void testElementTextMatchesWithBy() {
        this.textInput.clear();
        this.textInput.sendKeys(new CharSequence[]{"florence and the machine"});
        this.updateButton.click();
        Graphene.waitModel().until().element(BY_HEADER).text().matches("[fF]lorenc. and (the)? [mM]a.hine");
        this.textInput.sendKeys(new CharSequence[]{"Tested Header"});
        this.updateButton.click();
        ((StringMatcher)Graphene.waitModel().until().element(BY_HEADER).text().not()).matches("[fF]lorenc. and (the)? [mM]a.hine");
    }
}

