/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.drone;

import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.ftest.StubbedHttpServerRule;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;

@RunWith(value=Arquillian.class)
@RunAsClient
public class GrapheneDroneWebDriverIntegrationTestCase {
    @ClassRule
    public static final StubbedHttpServerRule httpServer = new StubbedHttpServerRule(4321);
    @Drone
    WebDriver browser;

    @Test
    public void created_instance_should_be_instance_of_requested_driver() {
        Assert.assertTrue((String)"browser must be WebDriver", (boolean)(this.browser instanceof WebDriver));
    }

    @Test
    public void created_instance_should_be_instance_of_GrapheneProxyInstance() {
        Assert.assertTrue((String)"browser must be proxy", (boolean)(this.browser instanceof GrapheneProxyInstance));
    }

    @Test
    public void context_instance_should_be_instance_of_requested_driver() {
        Assert.assertTrue((String)"context browser must be WebDriver", (boolean)(GrapheneContext.getContextFor(Default.class).getWebDriver(new Class[0]) instanceof WebDriver));
    }

    @Test
    public void context_instance_should_be_instance_of_GrapheneProxyInstance() {
        Assert.assertTrue((String)"context browser must be proxy", (boolean)(this.browser instanceof GrapheneProxyInstance));
    }

    @Test
    public void created_instance_should_be_able_to_navigate_to_some_page() {
        this.browser.navigate().to("http://127.0.0.1:" + httpServer.getPort());
    }

    @Test
    public void context_instance_should_be_able_to_navigate_to_some_page() {
        GrapheneContext.getContextFor(Default.class).getWebDriver(new Class[0]).navigate().to("http://127.0.0.1:" + httpServer.getPort());
    }
}

