/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.context;

import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.context.GrapheneProxyInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.openqa.selenium.WebDriver;

public class TestGrapheneContextHolding {
    @Mock
    WebDriver driver;
    @Mock(extraInterfaces={GrapheneProxyInstance.class})
    WebDriver driverProxy;

    @Before
    public void initMocks() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void when_instance_is_provided_to_context_then_context_holds_it() {
        GrapheneContext.set((WebDriver)this.driver);
        Assert.assertSame((Object)this.driver, (Object)GrapheneContext.get());
    }

    @Test
    public void when_instance_is_provided_to_context_then_context_is_initialized() {
        GrapheneContext.set((WebDriver)this.driver);
        Assert.assertTrue((boolean)GrapheneContext.isInitialized());
    }

    @Test
    public void when_context_is_reset_then_context_is_not_initialized() {
        GrapheneContext.set((WebDriver)this.driver);
        GrapheneContext.reset();
        Assert.assertFalse((boolean)GrapheneContext.isInitialized());
    }

    @Test(expected=NullPointerException.class)
    public void when_calling_get_on_not_initialized_context_then_context_throws_exception() {
        GrapheneContext.get();
    }

    @Test(expected=IllegalArgumentException.class)
    public void when_set_null_instance_to_context_then_context_throws_exception() {
        GrapheneContext.set(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void when_set_proxy_instance_to_context_then_context_throws_exception() {
        GrapheneContext.set((WebDriver)this.driverProxy);
    }
}

