/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import org.jboss.arquillian.graphene.enricher.AbstractPageFragmentStub;
import org.jboss.arquillian.graphene.enricher.Factory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class TestFactoryClass {
    private AbstractPageFragmentStub abstrPageFragmentStub;
    private final String ROOT_METHOD_RETURN_VAL = "root";
    private final String REF_BY_CLASS_METHOD_RETURN_VAL = "refByClassName";

    @Before
    public void initializeMocks() {
        this.abstrPageFragmentStub = (AbstractPageFragmentStub)Factory.initializePageFragment(AbstractPageFragmentStub.class, (WebElement)this.createRoot());
    }

    @Test
    public void testInitializedPageFragmentIsNotNull() {
        Assert.assertNotNull((String)"The initialized page fragment can not be null!", (Object)this.abstrPageFragmentStub);
    }

    @Test
    public void testIsRootInitialized() {
        Assert.assertNotNull((String)"Root should be initialized!", (Object)this.abstrPageFragmentStub.getRootProxy());
    }

    @Test
    public void testMethodInvocationOnRoot() {
        Assert.assertEquals((String)"The return value of method invoked on root element is wrong!", (Object)this.abstrPageFragmentStub.invokeMethodOnRoot(), (Object)"root");
    }

    @Test
    public void testMethodInvocationOnReferencedElement() {
        Assert.assertEquals((String)"The method onvoked on referenced element returned wrong value!", (Object)this.abstrPageFragmentStub.invokeMethodOnElementRefByClass(), (Object)"refByClassName");
    }

    private WebElement createRoot() {
        WebElement root = (WebElement)Mockito.mock(WebElement.class);
        Mockito.when((Object)root.getText()).thenReturn((Object)"root");
        WebElement elemByClass = (WebElement)Mockito.mock(WebElement.class);
        Mockito.when((Object)elemByClass.getText()).thenReturn((Object)"refByClassName");
        Mockito.when((Object)root.findElement(By.className((String)Matchers.anyString()))).thenReturn((Object)elemByClass);
        return root;
    }
}

