/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.condition.element;

import org.jboss.arquillian.graphene.condition.AbstractBooleanConditionFactory;
import org.jboss.arquillian.graphene.condition.BooleanConditionWrapper;
import org.jboss.arquillian.graphene.condition.ElementConditionFactory;
import org.jboss.arquillian.graphene.condition.element.ElementIsPresent;
import org.jboss.arquillian.graphene.condition.element.ElementTextContains;
import org.jboss.arquillian.graphene.condition.element.ElementTextEquals;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebElementConditionFactory
extends AbstractBooleanConditionFactory<ElementConditionFactory>
implements ElementConditionFactory {
    private WebElement element;

    public WebElementConditionFactory(WebElement element) {
        if (element == null) {
            throw new IllegalArgumentException("The element can't be null.");
        }
        this.element = element;
    }

    @Override
    public ExpectedCondition<Boolean> isPresent() {
        return new ElementIsPresent(this.element, this.getNegation());
    }

    @Override
    public ExpectedCondition<Boolean> isSelected() {
        return ExpectedConditions.elementSelectionStateToBe((WebElement)this.element, (!this.getNegation() ? 1 : 0) != 0);
    }

    @Override
    public ExpectedCondition<Boolean> isVisible() {
        return new BooleanConditionWrapper(ExpectedConditions.visibilityOf((WebElement)this.element), this.getNegation(), NoSuchElementException.class);
    }

    @Override
    public ExpectedCondition<Boolean> textContains(String expected) {
        return new ElementTextContains(this.element, expected, this.getNegation());
    }

    @Override
    public ExpectedCondition<Boolean> textEquals(String expected) {
        return new ElementTextEquals(this.element, expected, this.getNegation());
    }

    @Override
    protected WebElementConditionFactory copy() {
        WebElementConditionFactory copy = new WebElementConditionFactory(this.element);
        copy.setNegation(this.getNegation());
        return copy;
    }
}

