/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.configuration;

import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.graphene.configuration.GrapheneConfiguration;
import org.jboss.arquillian.graphene.configuration.SecurityActions;
import org.jboss.arquillian.graphene.context.GrapheneConfigurationContext;
import org.jboss.arquillian.graphene.spi.configuration.GrapheneConfigured;
import org.jboss.arquillian.graphene.spi.configuration.GrapheneUnconfigured;
import org.jboss.arquillian.test.spi.annotation.SuiteScoped;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrapheneConfigurator {
    private static final Logger LOGGER = Logger.getLogger(GrapheneConfigurator.class);
    @Inject
    @SuiteScoped
    private InstanceProducer<GrapheneConfiguration> configuration;
    @Inject
    private Event<GrapheneConfigured> configuredEvent;
    @Inject
    private Event<GrapheneUnconfigured> unconfiguredEvent;

    public void configureGraphene(@Observes BeforeClass event, ArquillianDescriptor descriptor) {
        GrapheneConfiguration c = new GrapheneConfiguration();
        this.configuration.set((Object)c);
        GrapheneConfigurator.map(descriptor, c, "graphene");
        GrapheneConfigurator.mapFromSystemProperties(c, "graphene");
        this.configuredEvent.fire((Object)new GrapheneConfigured());
        GrapheneConfigurationContext.set(c);
    }

    public void unconfigureGraphene(@Observes AfterClass event) {
        GrapheneConfigurationContext.reset();
        this.unconfiguredEvent.fire((Object)new GrapheneUnconfigured());
    }

    private static void mapFromSystemProperties(Object target, String descriptorQualifier) {
        String prefix = "arquillian." + descriptorQualifier + ".";
        Map<String, Field> fields = SecurityActions.getAccessableFields(target.getClass());
        Map<String, String> candidates = SecurityActions.getProperties(prefix);
        for (Map.Entry<String, String> candidate : candidates.entrySet()) {
            String propertyName = GrapheneConfigurator.keyTransformReverse(candidate.getKey().substring(prefix.isEmpty() ? 0 : prefix.length(), candidate.getKey().length()));
            GrapheneConfigurator.set(fields, target, propertyName, candidate.getValue());
        }
    }

    private static void map(ArquillianDescriptor descriptor, Object target, String descriptorQualifier) {
        for (ExtensionDef extensionDef : descriptor.getExtensions()) {
            if (!extensionDef.getExtensionName().equals(descriptorQualifier)) continue;
            GrapheneConfigurator.map(extensionDef, target);
            return;
        }
    }

    private static void map(ExtensionDef descriptor, Object target) {
        Map<String, Field> fields = SecurityActions.getAccessableFields(target.getClass());
        for (Map.Entry candidate : descriptor.getExtensionProperties().entrySet()) {
            String propertyName = GrapheneConfigurator.keyTransformReverse((String)candidate.getKey());
            GrapheneConfigurator.set(fields, target, propertyName, (String)candidate.getValue());
        }
    }

    private static void set(Map<String, Field> fields, Object target, String propertyName, String propertyValue) {
        Field field = fields.get(propertyName);
        if (field == null) {
            LOGGER.warn((Object)("You are trying to set '" + propertyName + "' property, but there is no property with this name in Graphene configuration."));
        } else if (field.getAnnotation(Deprecated.class) != null) {
            LOGGER.warn((Object)("The property called '" + propertyName + "' is deprecated in Graphene configuration."));
        } else {
            try {
                field.set(target, GrapheneConfigurator.convert(GrapheneConfigurator.box(field.getType()), propertyValue));
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't map Graphene configuration for " + target.getClass().getName() + ".");
            }
        }
    }

    private static String keyTransformReverse(String propertyName) {
        StringBuilder sb = new StringBuilder();
        boolean upperCaseFlag = false;
        for (int i = 0; i < propertyName.length(); ++i) {
            char c = propertyName.charAt(i);
            if (c == '.') {
                upperCaseFlag = true;
                continue;
            }
            if (upperCaseFlag && Character.isLowerCase(c)) {
                sb.append(Character.toUpperCase(c));
                upperCaseFlag = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static Class<?> box(Class<?> primitive) {
        if (!primitive.isPrimitive()) {
            return primitive;
        }
        if (Integer.TYPE.equals(primitive)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(primitive)) {
            return Long.class;
        }
        if (Float.TYPE.equals(primitive)) {
            return Float.class;
        }
        if (Double.TYPE.equals(primitive)) {
            return Double.class;
        }
        if (Short.TYPE.equals(primitive)) {
            return Short.class;
        }
        if (Boolean.TYPE.equals(primitive)) {
            return Boolean.class;
        }
        if (Character.TYPE.equals(primitive)) {
            return Character.class;
        }
        if (Byte.TYPE.equals(primitive)) {
            return Byte.class;
        }
        throw new IllegalArgumentException("Unknown primitive type " + primitive);
    }

    private static <T> T convert(Class<T> clazz, String value) {
        if (String.class.equals(clazz)) {
            return clazz.cast(value);
        }
        if (Integer.class.equals(clazz)) {
            return clazz.cast(Integer.valueOf(value));
        }
        if (Double.class.equals(clazz)) {
            return clazz.cast(Double.valueOf(value));
        }
        if (Long.class.equals(clazz)) {
            return clazz.cast(Long.valueOf(value));
        }
        if (Boolean.class.equals(clazz)) {
            return clazz.cast(Boolean.valueOf(value));
        }
        if (URL.class.equals(clazz)) {
            try {
                return clazz.cast(new URI(value).toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Unable to convert value " + value + " to URL", e);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to convert value " + value + " to URL", e);
            }
        }
        if (URI.class.equals(clazz)) {
            try {
                return clazz.cast(new URI(value));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to convert value " + value + " to URL", e);
            }
        }
        throw new IllegalArgumentException("Unable to convert value " + value + "to a class: " + clazz.getName());
    }
}

