/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.jboss.arquillian.graphene.spi.annotations.Root;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Factory {
    public static <T> T initializePageFragment(Class<T> clazz, final WebElement root) {
        Field[] declaredFields;
        if (root == null || clazz == null) {
            throw new IllegalArgumentException("Non of the parameters can be null!");
        }
        T pageFragment = Factory.instantiatePageFragment(clazz);
        for (Field i : declaredFields = clazz.getDeclaredFields()) {
            Annotation[] annotations;
            for (Annotation j : annotations = i.getAnnotations()) {
                if (j instanceof Root) {
                    WebElement rootElement = GrapheneProxy.getProxyForTargetWithInterfaces(root, WebElement.class);
                    try {
                        boolean accessible = i.isAccessible();
                        if (!accessible) {
                            i.setAccessible(true);
                        }
                        i.set(pageFragment, rootElement);
                        if (!accessible) {
                            i.setAccessible(false);
                        }
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("cannot set root element");
                    }
                }
                if (!(j instanceof FindBy)) continue;
                final By findBy = Factory.getReferencedBy((FindBy)j);
                WebElement referencedElement = (WebElement)GrapheneProxy.getProxyForFutureTarget(new GrapheneProxy.FutureTarget(){

                    public Object getTarget() {
                        return root.findElement(findBy);
                    }
                }, WebElement.class, new Class[0]);
                try {
                    boolean accessible = i.isAccessible();
                    if (!accessible) {
                        i.setAccessible(true);
                    }
                    i.set(pageFragment, referencedElement);
                    if (!accessible) continue;
                    i.setAccessible(false);
                }
                catch (Exception e) {
                    throw new IllegalStateException("cannot set referenced element!");
                }
            }
        }
        return pageFragment;
    }

    public static <T> T instantiatePageFragment(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static By getReferencedBy(FindBy findByAnnotation) {
        String value = null;
        value = findByAnnotation.className().trim();
        if (!value.isEmpty()) {
            return By.className((String)value);
        }
        value = findByAnnotation.css().trim();
        if (!value.isEmpty()) {
            return By.cssSelector((String)value);
        }
        value = findByAnnotation.id().trim();
        if (!value.isEmpty()) {
            return By.id((String)value);
        }
        value = findByAnnotation.xpath().trim();
        if (!value.isEmpty()) {
            return By.xpath((String)value);
        }
        value = findByAnnotation.name().trim();
        if (!value.isEmpty()) {
            return By.name((String)value);
        }
        value = findByAnnotation.tagName().trim();
        if (!value.isEmpty()) {
            return By.tagName((String)value);
        }
        value = findByAnnotation.linkText().trim();
        if (!value.isEmpty()) {
            return By.linkText((String)value);
        }
        value = findByAnnotation.partialLinkText().trim();
        if (!value.isEmpty()) {
            return By.partialLinkText((String)value);
        }
        return null;
    }
}

