/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.page.extension;

import java.util.Collection;
import org.apache.commons.lang.Validate;
import org.jboss.arquillian.graphene.page.extension.PageExtensionInstallator;
import org.jboss.arquillian.graphene.page.extension.PageExtensionInstallatorProvider;
import org.jboss.arquillian.graphene.spi.javascript.JavaScript;
import org.jboss.arquillian.graphene.spi.page.PageExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPageExtensionInstallator
implements PageExtensionInstallator {
    private final PageExtensionInstallatorProvider installatorProvider;
    private final PageExtension extension;

    public AbstractPageExtensionInstallator(PageExtension extension, PageExtensionInstallatorProvider installatorProvider) {
        Validate.notNull((Object)extension);
        Validate.notNull((Object)installatorProvider);
        this.extension = extension;
        this.installatorProvider = installatorProvider;
    }

    @Override
    public void install() {
        if (this.isInstalled()) {
            return;
        }
        for (String required : this.getRequired()) {
            this.installatorProvider.installator(required, false).install();
        }
        this.installWithoutRequirements();
        if (!this.isInstalled()) {
            throw new IllegalStateException("The page extension '" + this.extension.getClass() + "' can't be installed.");
        }
    }

    public JavaScript getExtensionScript() {
        return this.extension.getExtensionScript();
    }

    public JavaScript getInstallationDetectionScript() {
        return this.extension.getInstallationDetectionScript();
    }

    public String getName() {
        return this.extension.getName();
    }

    public Collection<String> getRequired() {
        return this.extension.getRequired();
    }

    protected abstract void installWithoutRequirements();
}

