/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import net.sf.cglib.core.DefaultNamingPolicy;
import net.sf.cglib.core.NamingPolicy;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.NoOp;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClassImposterizer {
    static final ClassImposterizer INSTANCE = new ClassImposterizer();
    private final Objenesis objenesis = new ObjenesisStd();
    private static final NamingPolicy DEFAULT_POLICY = new DefaultNamingPolicy(){

        protected String getTag() {
            return "CGLIB";
        }
    };
    private static final NamingPolicy SIGNED_CLASSES_POLICY = new DefaultNamingPolicy(){

        public String getClassName(String prefix, String source, Object key, Predicate names) {
            return "codegen." + super.getClassName(prefix, source, key, names);
        }

        protected String getTag() {
            return "CGLIB";
        }
    };
    private static final CallbackFilter IGNORE_BRIDGE_METHODS = new CallbackFilter(){

        public int accept(Method method) {
            return method.isBridge() ? 1 : 0;
        }
    };

    private ClassImposterizer() {
    }

    <T> T imposterise(Callback callback, Class<T> mockedType, Class<?> ... ancillaryTypes) {
        this.setConstructorsAccessible(mockedType, true);
        Class<?> proxyClass = this.createProxyClass(mockedType, ancillaryTypes);
        return mockedType.cast(this.createProxy(proxyClass, callback));
    }

    private void setConstructorsAccessible(Class<?> mockedType, boolean accessible) {
        for (Constructor<?> constructor : mockedType.getDeclaredConstructors()) {
            constructor.setAccessible(accessible);
        }
    }

    private Class<?> createProxyClass(Class<?> mockedType, Class<?> ... interfaces) {
        if (mockedType == Object.class) {
            mockedType = ClassWithSuperclassToWorkAroundCglibBug.class;
        }
        ClassEnhancer enhancer = new ClassEnhancer();
        enhancer.setUseFactory(true);
        enhancer.setSuperclass(mockedType);
        enhancer.setInterfaces(interfaces);
        enhancer.setCallbackTypes(new Class[]{MethodInterceptor.class, NoOp.class});
        enhancer.setCallbackFilter(IGNORE_BRIDGE_METHODS);
        enhancer.setNamingPolicy(mockedType.getSigners() != null ? SIGNED_CLASSES_POLICY : DEFAULT_POLICY);
        return enhancer.createClass();
    }

    private Object createProxy(Class<?> proxyClass, Callback callback) {
        Factory proxy = (Factory)this.objenesis.newInstance(proxyClass);
        proxy.setCallbacks(new Callback[]{callback, NoOp.INSTANCE});
        return proxy;
    }

    public static class ClassWithSuperclassToWorkAroundCglibBug {
    }

    private static class ClassEnhancer
    extends Enhancer {
        private ClassEnhancer() {
        }

        protected void filterConstructors(Class sc, List constructors) {
        }
    }
}

